/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories;

import com.atlassian.fecru.gwt.admin.shared.repositories.ActivityLog;
import com.atlassian.fecru.gwt.admin.shared.repositories.EngineError;
import com.atlassian.fecru.gwt.admin.shared.repositories.EngineErrorState;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryIndexingDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryState;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RepositoryOperationalSummary
implements IsSerializable {
    private boolean enabled;
    private boolean pipelined;
    private boolean upgrading;
    private boolean waitingForFirstSlurp;
    private boolean pollingDisabled;
    private RepositoryState state;
    private String infoMessage;
    private EngineErrorState engineErrors;
    private Map<ProcessingState, Integer> indexingState;
    private String lastUpdateDescription;
    private List<ActivityLog> recentActivity;
    private boolean obsolete;
    private int totalChangesets;
    private int totalIndexingWork;
    private int completedIndexingWork;
    private int completedScanningWork;
    private boolean scanningComplete;
    private boolean indexingComplete;
    private boolean paused;
    private long pauseEndSeconds;
    private RepositoryIndexingDetails indexingDetails;

    public RepositoryOperationalSummary() {
    }

    public RepositoryOperationalSummary(boolean enabled, RepositoryState state) {
        this.enabled = enabled;
        this.state = state;
        this.engineErrors = new EngineErrorState(new ArrayList<EngineError>(0), false);
    }

    public RepositoryOperationalSummary(RepositoryState state, String infoMessage, EngineErrorState engineErrors, Map<ProcessingState, Integer> pipelineState, String lastUpdateDescription, RepositoryIndexingDetails indexingDetails, List<ActivityLog> recentActivity, int totalChangesets, int totalIndexingWork, int completedIndexingWork, int completedScanningWork, boolean isPipelined, boolean isUpgrading, boolean waitingForFirstSlurp, boolean scanningComplete, boolean indexingComplete, boolean pollingDisabled, boolean paused, long pauseEndSeconds) {
        this(true, state);
        this.infoMessage = infoMessage;
        this.engineErrors = engineErrors;
        this.indexingState = pipelineState;
        this.lastUpdateDescription = lastUpdateDescription;
        this.indexingDetails = indexingDetails;
        this.recentActivity = recentActivity;
        this.totalChangesets = totalChangesets;
        this.totalIndexingWork = totalIndexingWork;
        this.completedIndexingWork = completedIndexingWork;
        this.completedScanningWork = completedScanningWork;
        this.pipelined = isPipelined;
        this.upgrading = isUpgrading;
        this.waitingForFirstSlurp = waitingForFirstSlurp;
        this.scanningComplete = scanningComplete;
        this.indexingComplete = indexingComplete;
        this.pollingDisabled = pollingDisabled;
        this.paused = paused;
        this.pauseEndSeconds = pauseEndSeconds;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public RepositoryState getState() {
        return this.state;
    }

    public void setState(RepositoryState state) {
        this.state = state;
    }

    public String getInfoMessage() {
        return this.infoMessage;
    }

    public void setInfoMessage(String infoMessage) {
        this.infoMessage = infoMessage;
    }

    public String getLastUpdateDescription() {
        return this.lastUpdateDescription;
    }

    public EngineErrorState getEngineErrors() {
        return this.engineErrors;
    }

    public void setEngineErrors(EngineErrorState engineErrors) {
        this.engineErrors = engineErrors;
    }

    public String getEngineErrorString() {
        if (!this.engineErrors.hasError()) {
            return null;
        }
        EngineError e2 = this.engineErrors.getCurrentError();
        return SafeHtmlUtils.htmlEscape((String)(e2.getTime().toString() + ": " + e2.getMessage())) + (e2.getHelpLink() == null ? "" : " <a href='" + SafeHtmlUtils.htmlEscape((String)e2.getHelpLink()) + "'>Help</a>");
    }

    public void setLastUpdateDescription(String lastUpdateDescription) {
        this.lastUpdateDescription = lastUpdateDescription;
    }

    public RepositoryIndexingDetails getIndexingDetails() {
        return this.indexingDetails;
    }

    public void setIndexingDetails(RepositoryIndexingDetails indexingDetails) {
        this.indexingDetails = indexingDetails;
    }

    public Map<ProcessingState, Integer> getIndexingState() {
        return this.indexingState;
    }

    public void setIndexingState(Map<ProcessingState, Integer> indexingState) {
        this.indexingState = indexingState;
    }

    public List<ActivityLog> getRecentActivity() {
        return this.recentActivity;
    }

    public void setRecentActivity(List<ActivityLog> recentActivity) {
        this.recentActivity = recentActivity;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }

    public int getTotalChangesets() {
        return this.totalChangesets;
    }

    public int getTotalIndexingWork() {
        return this.totalIndexingWork;
    }

    public int getCompletedIndexingWork() {
        return this.completedIndexingWork;
    }

    public boolean isScanning() {
        return !this.scanningComplete;
    }

    public boolean isIndexing() {
        return !this.indexingComplete;
    }

    public boolean isPipelined() {
        return this.pipelined;
    }

    public int getCompletedScanningWork() {
        return this.completedScanningWork;
    }

    public boolean isUpgrading() {
        return this.upgrading;
    }

    public boolean isWaitingForFirstSlurp() {
        return this.waitingForFirstSlurp;
    }

    public boolean isWaitingManualPoll() {
        return this.pollingDisabled && (this.waitingForFirstSlurp || this.indexingComplete);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getPauseEndSeconds() {
        return this.pauseEndSeconds;
    }

    public static enum ProcessingState implements IsSerializable
    {
        SCANNED("Changesets scanned"),
        INFILLED("Path expanded"),
        METADATA_INDEXED("Metadata indexed"),
        CONTENT_INDEXED("Content indexed"),
        COMPLETE("Changesets done");

        private final String caption;

        private ProcessingState(String caption) {
            this.caption = caption;
        }

        public String getCaption() {
            return this.caption;
        }
    }
}

