/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories;

public enum RepositoryKind {
    CVS("CVS"){

        @Override
        public <T> T map(Mapper<T> mapper) {
            return mapper.forCvs();
        }
    }
    ,
    SUBVERSION("Subversion"){

        @Override
        public <T> T map(Mapper<T> mapper) {
            return mapper.forSubversion();
        }
    }
    ,
    GIT("Git"){

        @Override
        public <T> T map(Mapper<T> mapper) {
            return mapper.forGit();
        }
    }
    ,
    PERFORCE("Perforce"){

        @Override
        public <T> T map(Mapper<T> mapper) {
            return mapper.forPerforce();
        }
    }
    ,
    CLEARCASE("ClearCase"){

        @Override
        public <T> T map(Mapper<T> mapper) {
            return mapper.forDisabled();
        }
    }
    ,
    MERCURIAL("Mercurial"){

        @Override
        public <T> T map(Mapper<T> mapper) {
            return mapper.forMercurial();
        }
    };

    private final String prettyName;

    private RepositoryKind(String prettyName) {
        this.prettyName = prettyName;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public abstract <T> T map(Mapper<T> var1);

    public static interface Mapper<T> {
        public T forCvs();

        public T forSubversion();

        public T forGit();

        public T forPerforce();

        public T forDisabled();

        public T forMercurial();
    }
}

