/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.repositories;

import com.atlassian.fecru.gwt.admin.shared.repositories.AuthenticationOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.DvcsRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryKind;
import com.google.gwt.user.client.rpc.IsSerializable;

public class GitRepositoryDetails
extends DvcsRepositoryDetails {
    private String path;
    private AdvancedOptions advancedOptions;

    public GitRepositoryDetails() {
    }

    public GitRepositoryDetails(String name, String description, String repoLocation, String path, AuthenticationOptions authOptions, AdvancedOptions advancedOptions) {
        super(RepositoryKind.GIT, name, description, repoLocation, authOptions);
        this.path = path;
        this.advancedOptions = advancedOptions;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AdvancedOptions getAdvancedOptions() {
        return this.advancedOptions;
    }

    public void setAdvancedOptions(AdvancedOptions advancedOptions) {
        this.advancedOptions = advancedOptions;
    }

    public static class AdvancedOptions
    implements IsSerializable {
        private boolean storeDiffInfo;
        private Integer blockSize;
        private String commandTimeout;
        private RenameDetection renameDetection;

        public AdvancedOptions() {
        }

        public AdvancedOptions(boolean storeDiffInfo, Integer blockSize, RenameDetection renameDetection, String commandTimeout) {
            this.storeDiffInfo = storeDiffInfo;
            this.blockSize = blockSize;
            this.renameDetection = renameDetection;
            this.commandTimeout = commandTimeout;
        }

        public String getCommandTimeout() {
            return this.commandTimeout;
        }

        public void setCommandTimeout(String commandTimeout) {
            this.commandTimeout = commandTimeout;
        }

        public boolean isStoreDiffInfo() {
            return this.storeDiffInfo;
        }

        public void setStoreDiffInfo(boolean storeDiffInfo) {
            this.storeDiffInfo = storeDiffInfo;
        }

        public Integer getBlockSize() {
            return this.blockSize;
        }

        public void setBlockSize(Integer blockSize) {
            this.blockSize = blockSize;
        }

        public RenameDetection getRenameDetection() {
            return this.renameDetection;
        }

        public void setRenameDetection(RenameDetection renameDetection) {
            this.renameDetection = renameDetection;
        }
    }

    public static enum RenameDetection {
        NONE(1),
        COPIES(2),
        MOVES(3),
        DETAILED(4);

        public final int renameOption;

        private RenameDetection(int renameOption) {
            this.renameOption = renameOption;
        }

        public static RenameDetection fromString(String name) {
            if (name != null) {
                for (RenameDetection renameDetection : RenameDetection.values()) {
                    if (!name.equalsIgnoreCase(renameDetection.name())) continue;
                    return renameDetection;
                }
            }
            return null;
        }

        public static RenameDetection fromInt(Integer renameOption) {
            if (renameOption != null) {
                for (RenameDetection renameDetection : RenameDetection.values()) {
                    if (renameDetection.renameOption != renameOption) continue;
                    return renameDetection;
                }
            }
            return null;
        }
    }
}

