/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.shared.auth;

public enum AuthenticationStyle {
    NO_AUTH("No authentication", null, "FishEye will not add any authentication to requests. Authentication will be handled transparently by the SCM."){

        @Override
        public void accept(Visitor v2) {
            v2.visitNoAuth();
        }
    }
    ,
    GEN_SSH_KEY_PAIR("Generate key pair for ssh", "a generated SSH key", "Generate a key pair, then upload the public key to your repository server. Note: SSH keys cannot be used for http(s) urls."){

        @Override
        public void accept(Visitor v2) {
            v2.visitGenSSHKeyPairAuth();
        }
    }
    ,
    UPLOAD_PRIVATE_KEY_WITH_NO_PASSPHRASE("Upload private key for ssh", "an uploaded SSH key", "Warning: you should understand the risks of uploading private keys. Note: SSH keys cannot be used for http(s) urls."){

        @Override
        public void accept(Visitor v2) {
            v2.visitUploadPrivateKeyAuth();
        }
    }
    ,
    PASSWORD("Password for http(s)", "a password", ""){

        @Override
        public void accept(Visitor v2) {
            v2.visitPasswordAuth();
        }
    };

    private final String title;
    private final String confirmMessage;
    private final String inlineHelp;

    private AuthenticationStyle(String title, String confirmMessage, String inlineHelp) {
        this.title = title;
        this.confirmMessage = confirmMessage;
        this.inlineHelp = inlineHelp;
    }

    public abstract void accept(Visitor var1);

    public String getTitle() {
        return this.title;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public String getInlineHelp() {
        return this.inlineHelp;
    }

    public static interface Visitor {
        public void visitNoAuth();

        public void visitGenSSHKeyPairAuth();

        public void visitUploadPrivateKeyAuth();

        public void visitPasswordAuth();
    }
}

