/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.repositories.CvsUpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.DefaultUpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.PolledUpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.UpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.validation.BaseValidator;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.cenqua.fisheye.util.Interval;

public class UpdateOptionsServerValidator
extends BaseValidator<UpdateOptions> {
    protected static final String FULLSCAN_GREATER_THAN_POLL_MSG = "Full scan interval must be at least as large as the polling interval";
    protected static final String INVALID_INTERVAL_MSG = "Invalid interval: ";

    public UpdateOptionsServerValidator(String stemId) {
        super(stemId);
    }

    @Override
    public ValidationMessages validate(UpdateOptions updateOptions, ValidationMessages messages) {
        if (updateOptions instanceof PolledUpdateOptions) {
            CvsUpdateOptions cvsUpdateOptions;
            PolledUpdateOptions polledUpdateOptions = (PolledUpdateOptions)updateOptions;
            Interval pollInterval = null;
            if (!Validator.Utils.isEmptyOrNull(polledUpdateOptions.getPollInterval()) && !polledUpdateOptions.isNeverPoll()) {
                try {
                    pollInterval = new Interval(polledUpdateOptions.getPollInterval(), 3);
                }
                catch (NumberFormatException e2) {
                    messages.addMessage(new ValidationMessage(this.withStem("pollInterval"), INVALID_INTERVAL_MSG + e2.getMessage()));
                }
            }
            if (updateOptions instanceof CvsUpdateOptions && !Validator.Utils.isEmptyOrNull((cvsUpdateOptions = (CvsUpdateOptions)updateOptions).getFullScanInterval()) && !cvsUpdateOptions.isNeverFullScan()) {
                try {
                    Interval fullScanInterval = new Interval(cvsUpdateOptions.getFullScanInterval());
                    if (pollInterval != null && fullScanInterval.compareTo(pollInterval) < 0) {
                        messages.addMessage(new ValidationMessage(this.withStem("fullScanInterval"), FULLSCAN_GREATER_THAN_POLL_MSG));
                    }
                }
                catch (NumberFormatException e3) {
                    messages.addMessage(new ValidationMessage(this.withStem("fullScanInterval"), INVALID_INTERVAL_MSG + e3.getMessage()));
                }
            }
        }
        if (updateOptions instanceof DefaultUpdateOptions) {
            new UpdateOptionsServerValidator(this.withStem("cvs.")).validate(((DefaultUpdateOptions)updateOptions).getCvsUpdateOptions(), messages);
            new UpdateOptionsServerValidator(this.withStem("polled.")).validate(((DefaultUpdateOptions)updateOptions).getPolledUpdateOptions(), messages);
        }
        return messages;
    }
}

