/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.repositories.SvnSymbolicRules;
import com.atlassian.fecru.gwt.admin.shared.repositories.SymbolicRule;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import java.nio.charset.Charset;

public class ServerValidationUtils {
    public static void validateOpTimeout(String opTimeout, String id, ValidationMessages messages) {
        ServerValidationUtils.validateInterval(opTimeout, id, "Operation timeout value is not a valid time interval. Examples of time intervals: \"25 seconds\", \"5 minutes\", \"2 hours\", \"2 days\"", messages);
    }

    public static void validateInterval(String opTimeout, String id, String message, ValidationMessages messages) {
        if (opTimeout != null) {
            Validator.Utils.ensure(RepositoryData.TIME_INTERVAL_REGEX.matcher(opTimeout).find(), id, message, messages);
        }
    }

    public static void validateCharset(String charset, String id, ValidationMessages messages) {
        if (charset != null && !Charset.availableCharsets().keySet().contains(charset)) {
            messages.addMessage(new ValidationMessage(id, String.format("Charset '%s' is not a valid charset.", charset)));
        }
    }

    public static ValidationMessages validateGlob(String value, String validationId, String messageIfNullOrEmpty, ValidationMessages messages) {
        Validator.Utils.ensureNotEmptyOrNull(value, validationId, messageIfNullOrEmpty, messages);
        return messages;
    }

    public static void validateCustomSvnSymbolicRules(SvnSymbolicRules customSymbolicRules, String validationId, ValidationMessages messages) {
        if (customSymbolicRules != null && !customSymbolicRules.isEmpty()) {
            int initialSize = messages.size();
            String message = "Symbolic rules cannot have an empty regular expression.";
            for (SymbolicRule rule : customSymbolicRules.getBranchRules()) {
                Validator.Utils.ensureNotEmptyOrNull(rule.getRegex(), validationId, message, messages);
                if (messages.size() <= initialSize) continue;
                return;
            }
            for (SymbolicRule rule : customSymbolicRules.getTagRules()) {
                Validator.Utils.ensureNotEmptyOrNull(rule.getRegex(), validationId, message, messages);
                if (messages.size() <= initialSize) continue;
                return;
            }
            for (SymbolicRule rule : customSymbolicRules.getTrunkRules()) {
                Validator.Utils.ensureNotEmptyOrNull(rule.getRegex(), validationId, message, messages);
                if (messages.size() <= initialSize) continue;
                return;
            }
        }
    }
}

