/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.server.repositories.validation.UpdateOptionsServerValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.AdvancedLinker;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.SimpleLinker;
import com.atlassian.fecru.gwt.admin.shared.repositories.TarballSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.defaults.validation.AdvancedLinkerClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.defaults.validation.SimpleLinkerClientValidator;
import com.atlassian.fecru.gwt.admin.shared.validation.BaseValidator;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;

public class RepositoryOptionsServerValidator
extends BaseValidator<RepositoryOptions> {
    private final SimpleLinkerClientValidator simpleLinkerValidator = new SimpleLinkerClientValidator(this.withStem("linkersSettings.linker."));
    private final AdvancedLinkerClientValidator advancedLinkerValidator = new AdvancedLinkerClientValidator(this.withStem("linkersSettings.linker."));
    private final UpdateOptionsServerValidator updateOptionsServerValidator = new UpdateOptionsServerValidator(this.withStem("updateOptions."));

    public RepositoryOptionsServerValidator(String stemId) {
        super(stemId);
    }

    @Override
    public ValidationMessages validate(RepositoryOptions options, ValidationMessages messages) {
        for (SimpleLinker simpleLinker : options.getLinkersSettings().getSimpleLinkers()) {
            this.simpleLinkerValidator.validate(simpleLinker, messages);
        }
        for (AdvancedLinker advancedLinker : options.getLinkersSettings().getAdvancedLinkers()) {
            this.advancedLinkerValidator.validate(advancedLinker, messages);
        }
        TarballSettings tarballSettings = options.getTarballsSettings();
        if (tarballSettings != null && tarballSettings.isEnabled()) {
            Validator.Utils.ensure(tarballSettings.getMaxFiles() >= 0L, this.withStem("tarballSettings.maxFiles"), "Must be greater than or equal to zero", messages);
        }
        this.updateOptionsServerValidator.validate(options.getUpdateOptions(), messages);
        return messages;
    }
}

