/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.server.repositories.validation.AuthenticationOptionsServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.ServerValidationUtils;
import com.atlassian.fecru.gwt.admin.shared.repositories.MercurialRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fecru.security.SshKeyManager;

public class MercurialRepositoryServerValidator
implements Validator<RepositoryDetails> {
    private final SshKeyManager sshKeyManager;

    public MercurialRepositoryServerValidator(SshKeyManager sshKeyManager) {
        this.sshKeyManager = sshKeyManager;
    }

    @Override
    public ValidationMessages validate(RepositoryDetails update, ValidationMessages messages) {
        if (update instanceof MercurialRepositoryDetails) {
            MercurialRepositoryDetails mercurialUpdate = (MercurialRepositoryDetails)update;
            if (mercurialUpdate.getAdvancedOptions() != null && !Validator.Utils.isEmptyOrNull(mercurialUpdate.getAdvancedOptions().getOpTimeout())) {
                ServerValidationUtils.validateOpTimeout(mercurialUpdate.getAdvancedOptions().getOpTimeout(), "mercurial.optimeout", messages);
            }
            messages = new AuthenticationOptionsServerValidator(this.sshKeyManager).validate(mercurialUpdate.getAuthenticationOptions(), messages);
        }
        return messages;
    }
}

