/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.server.repositories.validation.AuthenticationOptionsServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.ServerValidationUtils;
import com.atlassian.fecru.gwt.admin.shared.repositories.GitRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fecru.security.SshKeyManager;

public class GitRepositoryServerValidator
implements Validator<RepositoryDetails> {
    private final SshKeyManager sshKeyManager;

    public GitRepositoryServerValidator(SshKeyManager sshKeyManager) {
        this.sshKeyManager = sshKeyManager;
    }

    @Override
    public ValidationMessages validate(RepositoryDetails repositoryDetails, ValidationMessages messages) {
        if (repositoryDetails instanceof GitRepositoryDetails) {
            GitRepositoryDetails gitUpdate = (GitRepositoryDetails)repositoryDetails;
            if (gitUpdate.getAdvancedOptions() != null) {
                ServerValidationUtils.validateOpTimeout(gitUpdate.getAdvancedOptions().getCommandTimeout(), "git.commandTimeout", messages);
            }
            messages = new AuthenticationOptionsServerValidator(this.sshKeyManager).validate(gitUpdate.getAuthenticationOptions(), messages);
        }
        return messages;
    }
}

