/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.server.repositories.validation.ServerValidationUtils;
import com.atlassian.fecru.gwt.admin.shared.repositories.CvsRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import java.io.File;

public class CvsRepositoryServerValidator
implements Validator<RepositoryDetails> {
    @Override
    public ValidationMessages validate(RepositoryDetails update, ValidationMessages messages) {
        if (update instanceof CvsRepositoryDetails) {
            CvsRepositoryDetails cvsUpdate = (CvsRepositoryDetails)update;
            if (cvsUpdate.getDir() != null) {
                File verify = new File(cvsUpdate.getDir());
                if (!verify.exists()) {
                    messages.addMessage(new ValidationMessage("cvs.dir", String.format("The path \"%s\" doesn't appear to exist.", cvsUpdate.getDir())));
                } else if (!verify.isDirectory()) {
                    messages.addMessage(new ValidationMessage("cvs.dir", String.format("The path \"%s\" doesn't appear to be a directory.", cvsUpdate.getDir())));
                }
            }
            if (cvsUpdate.getAdvancedOptions() != null) {
                ServerValidationUtils.validateCharset(cvsUpdate.getAdvancedOptions().getCharset(), "cvs.charset", messages);
            }
        }
        return messages;
    }
}

