/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle;
import com.atlassian.fecru.gwt.admin.shared.repositories.AuthenticationOptions;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fecru.security.SshKeyManager;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import javax.servlet.http.HttpSession;

public class AuthenticationOptionsServerValidator
implements Validator<AuthenticationOptions> {
    private final SshKeyManager sshKeyManager;

    public AuthenticationOptionsServerValidator(SshKeyManager sshKeyManager) {
        this.sshKeyManager = sshKeyManager;
    }

    @Override
    public ValidationMessages validate(AuthenticationOptions authOpts, ValidationMessages messages) {
        if (authOpts != null) {
            try {
                Pair<String, String> key;
                if (AuthenticationStyle.UPLOAD_PRIVATE_KEY_WITH_NO_PASSPHRASE.equals((Object)authOpts.getStyle()) && (key = this.loadKeyFromSession(authOpts.getKeyName())).getSecond() != null && this.sshKeyManager.isEncrypted(key.getSecond())) {
                    messages.addMessage(new ValidationMessage("auth.ssh", "The key you have uploaded requires a passphrase"));
                }
            }
            catch (JSchException e2) {
                messages.addMessage(new ValidationMessage("auth.ssh", "Invalid private key: " + e2.getMessage()));
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }
        return messages;
    }

    private Pair<String, String> loadKeyFromSession(String keyname) {
        HttpSession session = TotalityFilter.getRequest().getSession();
        return Pair.newInstance((String)session.getAttribute(keyname + ".public"), (String)session.getAttribute(keyname + ".private"));
    }
}

