/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.validation;

import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;

public class AddRepositoryServerValidator
implements Validator<RepositoryDetails> {
    protected RepositoryAdminService repositoryAdminService;

    public AddRepositoryServerValidator(RepositoryAdminService repositoryAdminService) {
        this.repositoryAdminService = repositoryAdminService;
    }

    @Override
    public ValidationMessages validate(RepositoryDetails update, ValidationMessages messages) {
        if (update.getName() != null) {
            if (!RepositoryData.NAME_REGEX.matcher(update.getName()).find()) {
                messages.addMessage(new ValidationMessage("name", "Repository name must match the regular expression " + RepositoryData.NAME_REGEX.pattern()));
            }
            if (this.repositoryAdminService.exists(update.getName())) {
                messages.addMessage(new ValidationMessage("name", "A repository named \"" + update.getName() + "\" is already defined."));
            }
        }
        return messages;
    }
}

