/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.defaults.validation;

import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessage;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fisheye.spi.admin.data.SimpleLinker;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SimpleLinkerServerValidator
implements Validator<com.atlassian.fecru.gwt.admin.shared.repositories.SimpleLinker> {
    @Override
    public ValidationMessages validate(com.atlassian.fecru.gwt.admin.shared.repositories.SimpleLinker simpleLinker, ValidationMessages messages) {
        Pattern linkerRegex = null;
        if (messages.getFor("simple.regex") == null) {
            try {
                linkerRegex = Pattern.compile(simpleLinker.getRegex());
            }
            catch (PatternSyntaxException e2) {
                messages.addMessage(new ValidationMessage("simple.regex", "Invalid regular exception: " + e2.getMessage()));
            }
        }
        if (linkerRegex == null) {
            linkerRegex = Pattern.compile("");
        }
        if (messages.getFor("simple.href") == null) {
            SimpleLinker linker = new SimpleLinker(linkerRegex, "http://www.atlassian.com");
            try {
                linker.setHref(simpleLinker.getHref());
            }
            catch (IllegalArgumentException e3) {
                messages.addMessage(new ValidationMessage("simple.href", "Invalid href: " + e3.getMessage()));
            }
        }
        return messages;
    }
}

