/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories.defaults;

import com.atlassian.fecru.gwt.admin.shared.repositories.AdvancedLinker;
import com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePathGlob;
import com.atlassian.fecru.gwt.admin.shared.repositories.CommitMessageSyntaxSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.CvsUpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.DefaultUpdateOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.GroupPermission;
import com.atlassian.fecru.gwt.admin.shared.repositories.GroupPermissionsSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.HiddenDirsSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.SimpleLinker;
import com.atlassian.fecru.gwt.admin.shared.repositories.TarballSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.UpdateOptions;
import com.atlassian.fecru.page.OnePageRequest;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePath;
import com.atlassian.fisheye.spi.admin.data.CommitMessageSyntaxSettings;
import com.atlassian.fisheye.spi.admin.data.PolledUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.TarballSettings;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class RepositoryOptionsServerBuilder {
    public static com.atlassian.fecru.gwt.admin.shared.repositories.TarballSettings toTarballSettingsClientType(TarballSettings tarballSettings) {
        if (tarballSettings == null) {
            return null;
        }
        return new com.atlassian.fecru.gwt.admin.shared.repositories.TarballSettings(tarballSettings.isEnabled(), tarballSettings.getMaxFiles(), RepositoryOptionsServerBuilder.excludeToClientType(tarballSettings.getExcludes()));
    }

    public static List<CaseAwarePathGlob> globToClientType(List<com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob> allowExcludeGlobs) {
        LinkedList<CaseAwarePathGlob> includes = new LinkedList<CaseAwarePathGlob>();
        for (com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob include : allowExcludeGlobs) {
            includes.add(new CaseAwarePathGlob(include.getGlob(), include.isCaseSensitive()));
        }
        return includes;
    }

    public static List<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath> pathToClientType(List<CaseAwarePath> allowIncludePaths) {
        LinkedList<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath> excludes = new LinkedList<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath>();
        for (CaseAwarePath exclude : allowIncludePaths) {
            excludes.add(new com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath(exclude.getPath(), exclude.isCaseSensitive()));
        }
        return excludes;
    }

    private static List<TarballSettings.Exclude> excludeToClientType(List<TarballSettings.Exclude> excludeArray) {
        ArrayList<TarballSettings.Exclude> result = new ArrayList<TarballSettings.Exclude>(excludeArray.size());
        for (TarballSettings.Exclude exclude : excludeArray) {
            result.add(new TarballSettings.Exclude(exclude.getDirectoryPath(), exclude.isExcludeSubDirs()));
        }
        return result;
    }

    public static HiddenDirsSettings toHiddenDirsClientType(List<CaseAwarePath> hiddenDirs) {
        LinkedList<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath> result = new LinkedList<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath>();
        for (CaseAwarePath hiddenDir : hiddenDirs) {
            result.add(new com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath(hiddenDir.getPath(), hiddenDir.isCaseSensitive()));
        }
        return new HiddenDirsSettings(result);
    }

    public static List<SimpleLinker> toSimpleLinkersClientType(List<com.atlassian.fisheye.spi.admin.data.SimpleLinker> simpleLinkers) {
        ArrayList<SimpleLinker> linkers = new ArrayList<SimpleLinker>();
        for (com.atlassian.fisheye.spi.admin.data.SimpleLinker linker : simpleLinkers) {
            linkers.add(new SimpleLinker(linker.getDescription(), linker.getHref(), linker.getRegex().pattern()));
        }
        return linkers;
    }

    public static List<AdvancedLinker> toAdvancedLinkersClientType(List<com.atlassian.fisheye.spi.admin.data.AdvancedLinker> advancedLinkers) {
        ArrayList<AdvancedLinker> linkers = new ArrayList<AdvancedLinker>();
        for (com.atlassian.fisheye.spi.admin.data.AdvancedLinker linker : advancedLinkers) {
            linkers.add(new AdvancedLinker(linker.getDescription(), linker.getSyntaxDef()));
        }
        return linkers;
    }

    public static GroupPermissionsSettings toGroupsSecuritiesClientType(Set<String> requiredGroups) throws DbException {
        LinkedList<GroupPermission> groups = new LinkedList<GroupPermission>();
        for (GroupInfo groupName : AppConfig.getsConfig().getUserManager().searchGroups(GroupSearchCriteria.create(), OnePageRequest.createNoLimit()).getValues()) {
            groups.add(new GroupPermission(groupName.getName(), requiredGroups.contains(groupName.getName())));
        }
        return new GroupPermissionsSettings(groups);
    }

    public static com.atlassian.fecru.gwt.admin.shared.repositories.CommitMessageSyntaxSettings toCommitMessageSyntaxSettingsClientType(CommitMessageSyntaxSettings settings) {
        if (settings == null) {
            return null;
        }
        return new com.atlassian.fecru.gwt.admin.shared.repositories.CommitMessageSyntaxSettings(settings.getSyntaxType() == CommitMessageSyntaxSettings.SyntaxType.PLAIN ? CommitMessageSyntaxSettings.SyntaxType.PLAIN : CommitMessageSyntaxSettings.SyntaxType.WIKI, settings.getWikiSyntaxStartDate());
    }

    public static List<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath> toCaseAwarePaths(List<CaseAwarePath> paths) {
        LinkedList<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath> result = new LinkedList<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath>();
        for (CaseAwarePath path : paths) {
            result.add(new com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath(path.getPath(), path.isCaseSensitive()));
        }
        return result;
    }

    public static List<CaseAwarePathGlob> toCaseAwareGlobs(List<com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob> globs) {
        LinkedList<CaseAwarePathGlob> result = new LinkedList<CaseAwarePathGlob>();
        for (com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob glob : globs) {
            result.add(new CaseAwarePathGlob(glob.getGlob(), glob.isCaseSensitive()));
        }
        return result;
    }

    public static List<com.atlassian.fisheye.spi.admin.data.SimpleLinker> toSimpleLinkersServerType(List<SimpleLinker> simpleLinkers) {
        ArrayList<com.atlassian.fisheye.spi.admin.data.SimpleLinker> result = new ArrayList<com.atlassian.fisheye.spi.admin.data.SimpleLinker>(simpleLinkers.size());
        for (SimpleLinker simpleLinker : simpleLinkers) {
            com.atlassian.fisheye.spi.admin.data.SimpleLinker linker = new com.atlassian.fisheye.spi.admin.data.SimpleLinker(Pattern.compile(simpleLinker.getRegex()), simpleLinker.getHref());
            linker.setDescription(simpleLinker.getDescription());
            result.add(linker);
        }
        return result;
    }

    public static List<com.atlassian.fisheye.spi.admin.data.AdvancedLinker> toAdvancedLinkersServerType(List<AdvancedLinker> advancedLinkers) {
        ArrayList<com.atlassian.fisheye.spi.admin.data.AdvancedLinker> result = new ArrayList<com.atlassian.fisheye.spi.admin.data.AdvancedLinker>(advancedLinkers.size());
        for (AdvancedLinker advancedLinker : advancedLinkers) {
            com.atlassian.fisheye.spi.admin.data.AdvancedLinker linker = new com.atlassian.fisheye.spi.admin.data.AdvancedLinker(advancedLinker.getSyntaxDef());
            linker.setDescription(advancedLinker.getDescription());
            result.add(linker);
        }
        return result;
    }

    public static TarballSettings toTarballSettingsServerType(com.atlassian.fecru.gwt.admin.shared.repositories.TarballSettings tarballs) {
        TarballSettings result = new TarballSettings();
        result.setEnabled(tarballs.isEnabled());
        result.setMaxFiles(tarballs.getMaxFiles());
        ArrayList<TarballSettings.Exclude> excludes = new ArrayList<TarballSettings.Exclude>(tarballs.getExcludes().size());
        for (TarballSettings.Exclude exclude : tarballs.getExcludes()) {
            excludes.add(new TarballSettings.Exclude(exclude.getDirectoryPath(), exclude.isExcludeSubDirs()));
        }
        result.setExcludes(excludes);
        return result;
    }

    public static Set<String> toGroups(GroupPermissionsSettings groupPermissions) {
        HashSet<String> groups = new HashSet<String>();
        for (GroupPermission permission : groupPermissions.getGroups()) {
            if (!permission.isAllowRead()) continue;
            groups.add(permission.getName());
        }
        return groups;
    }

    public static List<CaseAwarePath> toCaseAwarePathsServerType(List<com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath> paths) {
        ArrayList<CaseAwarePath> result = new ArrayList<CaseAwarePath>(paths.size());
        for (com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePath path : paths) {
            result.add(new CaseAwarePath(path.getPath(), path.isCaseSensitive()));
        }
        return result;
    }

    public static List<com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob> toCaseAwarePathGlobsServerType(List<CaseAwarePathGlob> pathGlobs) {
        ArrayList<com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob> result = new ArrayList<com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob>(pathGlobs.size());
        for (CaseAwarePathGlob pathGlob : pathGlobs) {
            result.add(new com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob(pathGlob.getGlob(), pathGlob.isCaseSensitive()));
        }
        return result;
    }

    public static CommitMessageSyntaxSettings toCommitMessageSyntaxServerType(com.atlassian.fecru.gwt.admin.shared.repositories.CommitMessageSyntaxSettings commitMessageSyntaxSettings) {
        return new CommitMessageSyntaxSettings(commitMessageSyntaxSettings.getSyntaxType() == CommitMessageSyntaxSettings.SyntaxType.PLAIN ? CommitMessageSyntaxSettings.SyntaxType.PLAIN : CommitMessageSyntaxSettings.SyntaxType.WIKI, commitMessageSyntaxSettings.getStartDate());
    }

    public static UpdateOptions toUpdateOptionsClientType(com.atlassian.fisheye.spi.admin.data.UpdateOptions updateOptions) {
        if (updateOptions instanceof com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions) {
            com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions cvs = (com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions)updateOptions;
            return new CvsUpdateOptions(cvs.getHistoryFile(), cvs.getFullScanInterval(), cvs.getStripPrefix(), cvs.getPollInterval());
        }
        if (updateOptions instanceof PolledUpdateOptions) {
            PolledUpdateOptions polled = (PolledUpdateOptions)updateOptions;
            return new com.atlassian.fecru.gwt.admin.shared.repositories.PolledUpdateOptions(polled.getPollInterval());
        }
        if (updateOptions instanceof com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions) {
            com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions defaultUpdateOptions = (com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions)updateOptions;
            return new DefaultUpdateOptions((CvsUpdateOptions)RepositoryOptionsServerBuilder.toUpdateOptionsClientType((com.atlassian.fisheye.spi.admin.data.UpdateOptions)defaultUpdateOptions.getCvsUpdateOptions()), (com.atlassian.fecru.gwt.admin.shared.repositories.PolledUpdateOptions)RepositoryOptionsServerBuilder.toUpdateOptionsClientType((com.atlassian.fisheye.spi.admin.data.UpdateOptions)defaultUpdateOptions.getPolledUpdateOptions()));
        }
        return null;
    }

    public static com.atlassian.fisheye.spi.admin.data.UpdateOptions toUpdateOptionsServerType(UpdateOptions updateOptions) {
        if (updateOptions instanceof CvsUpdateOptions) {
            CvsUpdateOptions options = (CvsUpdateOptions)updateOptions;
            return new com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions(options.getPollInterval(), options.getFullScanInterval(), options.getHistoryFile(), options.getStripPrefix());
        }
        if (updateOptions instanceof com.atlassian.fecru.gwt.admin.shared.repositories.PolledUpdateOptions) {
            com.atlassian.fecru.gwt.admin.shared.repositories.PolledUpdateOptions options = (com.atlassian.fecru.gwt.admin.shared.repositories.PolledUpdateOptions)updateOptions;
            return new PolledUpdateOptions(options.getPollInterval());
        }
        if (updateOptions instanceof DefaultUpdateOptions) {
            DefaultUpdateOptions options = (DefaultUpdateOptions)updateOptions;
            return new com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions((com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions)RepositoryOptionsServerBuilder.toUpdateOptionsServerType(options.getCvsUpdateOptions()), (PolledUpdateOptions)RepositoryOptionsServerBuilder.toUpdateOptionsServerType(options.getPolledUpdateOptions()));
        }
        return null;
    }
}

