/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories;

import com.atlassian.fecru.gwt.admin.server.repositories.RepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.shared.repositories.SvnRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.SvnSymbolicRules;
import com.atlassian.fecru.gwt.admin.shared.repositories.SymbolicRule;
import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.spi.admin.data.SvnRepositoryData;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SvnRepositoryDetailsServerBuilder
implements RepositoryDetailsServerBuilder<SvnRepositoryData, SvnRepositoryDetails> {
    @Override
    public SvnRepositoryDetails toClientType(SvnRepositoryData repo) {
        SvnRepositoryDetails details = new SvnRepositoryDetails(repo.getName(), repo.getDescription(), repo.getUrl(), repo.getPath(), repo.getUsername(), repo.getPassword(), repo.getPassword() == null || repo.getPassword().equals(""), new SvnRepositoryDetails.AdvancedOptions(RepositoryDetailsServerBuilder.Utils.valueOf(repo.isStoreDiff()), repo.getBlockSize(), repo.getCommandTimeout(), repo.getConnectionsPerSecond(), RepositoryDetailsServerBuilder.Utils.charsetNameOf(repo.getCharset()), repo.getAccessCode(), repo.getStartRevision(), this.fromInitialImport(repo.getInitialImport()), RepositoryDetailsServerBuilder.Utils.valueOf(repo.isFollowBase()), RepositoryDetailsServerBuilder.Utils.valueOf(repo.isUsingInbuiltSymbolicRules()), this.customSymbolicRulesFor(repo)));
        details.setPassword(null);
        return details;
    }

    @Override
    public SvnRepositoryData toServerType(SvnRepositoryDetails details) {
        SvnRepositoryData svnRepositoryData = new SvnRepositoryData(details.getName(), details.getUrl());
        svnRepositoryData.setPath(details.getPath());
        svnRepositoryData.setUsername(details.getUsername());
        svnRepositoryData.setPassword(details.getPassword());
        svnRepositoryData.setDescription(details.getDescription());
        if (details.getAdvancedOptions() != null) {
            svnRepositoryData.setBlockSize(details.getAdvancedOptions().getBlockSize());
            svnRepositoryData.setCommandTimeout(details.getAdvancedOptions().getOpTimeout());
            svnRepositoryData.setConnectionsPerSecond(details.getAdvancedOptions().getThrottle());
            svnRepositoryData.setCharset(details.getAdvancedOptions().getCharset() == null ? null : Charset.forName(details.getAdvancedOptions().getCharset()));
            svnRepositoryData.setAccessCode(details.getAdvancedOptions().getAccessCode());
            svnRepositoryData.setStartRevision(details.getAdvancedOptions().getStartRevision());
            svnRepositoryData.setInitialImport(this.toInitialImport(details));
            svnRepositoryData.setFollowBase(Boolean.valueOf(details.getAdvancedOptions().isFollowBaseMoves()));
            svnRepositoryData.setUsingInbuiltSymbolicRules(Boolean.valueOf(details.getAdvancedOptions().isUseBuiltinSymbolicRules()));
            SvnSymbolicRules customSymbolicRules = details.getAdvancedOptions().getCustomSymbolicRules();
            if (customSymbolicRules != null) {
                svnRepositoryData.setTrunks(this.toSpiRules(customSymbolicRules.getTrunkRules()));
                svnRepositoryData.setBranches(this.toSpiRules(customSymbolicRules.getBranchRules()));
                svnRepositoryData.setTags(this.toSpiRules(customSymbolicRules.getTagRules()));
            } else {
                svnRepositoryData.setTrunks(Collections.emptyList());
                svnRepositoryData.setBranches(Collections.emptyList());
                svnRepositoryData.setTags(Collections.emptyList());
            }
            svnRepositoryData.setStoreDiff(details.getAdvancedOptions().isStoreDiffInfo());
        } else {
            svnRepositoryData.setUsingInbuiltSymbolicRules(Boolean.valueOf(true));
        }
        return svnRepositoryData;
    }

    private SvnSymbolicRules customSymbolicRulesFor(SvnRepositoryData repo) {
        return new SvnSymbolicRules(this.toSymbolicRules(repo.getTrunks()), this.toSymbolicRules(repo.getBranches()), this.toSymbolicRules(repo.getTags()));
    }

    private List<SymbolicRule> toSymbolicRules(Collection<SvnRepositoryData.SymbolicRule> rules) {
        LinkedList<SymbolicRule> result = new LinkedList<SymbolicRule>();
        for (SvnRepositoryData.SymbolicRule rule : rules) {
            result.add(new SymbolicRule(rule.getRegex(), rule.getName(), rule.getLogicalPathPrefix()));
        }
        return result;
    }

    private ImportMode toInitialImport(SvnRepositoryDetails details) {
        return details.getAdvancedOptions().getInitialImport() ? ImportMode.IMPORT_WITHOUT_TAGS : ImportMode.NO_IMPORT;
    }

    private boolean fromInitialImport(ImportMode importMode) {
        return ImportMode.IMPORT_WITHOUT_TAGS == importMode;
    }

    private Collection<SvnRepositoryData.SymbolicRule> toSpiRules(List<SymbolicRule> rules) {
        ArrayList<SvnRepositoryData.SymbolicRule> result = new ArrayList<SvnRepositoryData.SymbolicRule>(rules.size());
        for (SymbolicRule rule : rules) {
            result.add(new SvnRepositoryData.SymbolicRule(rule.getRegex(), rule.getName(), rule.getLogical()));
        }
        return result;
    }
}

