/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories;

import com.atlassian.fecru.gwt.admin.server.repositories.AuthenticationDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.RepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.shared.repositories.MercurialRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fisheye.spi.admin.data.HgRepositoryData;

public class MercurialRepositoryDetailsServerBuilder
implements RepositoryDetailsServerBuilder<HgRepositoryData, MercurialRepositoryDetails> {
    private AuthenticationDetailsServerBuilder authBuilder = new AuthenticationDetailsServerBuilder();

    @Override
    public MercurialRepositoryDetails toClientType(HgRepositoryData repo) {
        return new MercurialRepositoryDetails(repo.getName(), repo.getDescription(), repo.getLocation(), this.authBuilder.toClientType(repo.getAuthentication()), new MercurialRepositoryDetails.AdvancedOptions(RepositoryDetailsServerBuilder.Utils.valueOf(repo.isStoreDiff()), repo.getBlockSize(), repo.getCommandTimeout()));
    }

    @Override
    public HgRepositoryData toServerType(MercurialRepositoryDetails details) {
        HgRepositoryData hgRepositoryData = new HgRepositoryData(details.getName(), details.getRepoLocation());
        hgRepositoryData.setDescription(details.getDescription());
        hgRepositoryData.setAuthentication(this.authBuilder.toServerType(details.getAuthenticationOptions()));
        if (details.getAdvancedOptions() != null) {
            hgRepositoryData.setBlockSize(details.getAdvancedOptions().getBlockSize());
            if (!Validator.Utils.isEmptyOrNull(details.getAdvancedOptions().getOpTimeout())) {
                hgRepositoryData.setCommandTimeout(details.getAdvancedOptions().getOpTimeout());
            } else {
                hgRepositoryData.setCommandTimeout(null);
            }
            hgRepositoryData.setStoreDiff(details.getAdvancedOptions().isStoreDiffInfo());
        }
        return hgRepositoryData;
    }
}

