/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories;

import com.atlassian.fecru.gwt.admin.server.repositories.AuthenticationDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.RepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.shared.repositories.GitRepositoryDetails;
import com.atlassian.fisheye.spi.admin.data.GitRepositoryData;

public class GitRepositoryDetailsServerBuilder
implements RepositoryDetailsServerBuilder<GitRepositoryData, GitRepositoryDetails> {
    private AuthenticationDetailsServerBuilder authBuilder = new AuthenticationDetailsServerBuilder();

    @Override
    public GitRepositoryDetails toClientType(GitRepositoryData repo) {
        return new GitRepositoryDetails(repo.getName(), repo.getDescription(), repo.getLocation(), repo.getPath(), this.authBuilder.toClientType(repo.getAuthentication()), new GitRepositoryDetails.AdvancedOptions(RepositoryDetailsServerBuilder.Utils.valueOf(repo.isStoreDiff()), repo.getBlockSize(), this.fromRenameOptions(repo.getRenameOption()), repo.getCommandTimeout()));
    }

    @Override
    public GitRepositoryData toServerType(GitRepositoryDetails details) {
        GitRepositoryData gitRepositoryData = new GitRepositoryData(details.getName(), details.getRepoLocation());
        gitRepositoryData.setDescription(details.getDescription());
        gitRepositoryData.setPath(details.getPath());
        gitRepositoryData.setAuthentication(this.authBuilder.toServerType(details.getAuthenticationOptions()));
        if (details.getAdvancedOptions() != null) {
            gitRepositoryData.setBlockSize(details.getAdvancedOptions().getBlockSize());
            gitRepositoryData.setStoreDiff(details.getAdvancedOptions().isStoreDiffInfo());
            gitRepositoryData.setRenameOption(this.toRenameOptions(details.getAdvancedOptions().getRenameDetection()));
            gitRepositoryData.setCommandTimeout(details.getAdvancedOptions().getCommandTimeout());
        }
        return gitRepositoryData;
    }

    private Integer toRenameOptions(GitRepositoryDetails.RenameDetection renameDetection) {
        if (renameDetection == null) {
            return null;
        }
        switch (renameDetection) {
            case COPIES: {
                return 2;
            }
            case DETAILED: {
                return 4;
            }
            case MOVES: {
                return 3;
            }
            case NONE: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unexpected rename option");
    }

    private GitRepositoryDetails.RenameDetection fromRenameOptions(Integer renameOption) {
        if (renameOption == 2) {
            return GitRepositoryDetails.RenameDetection.COPIES;
        }
        if (renameOption == 4) {
            return GitRepositoryDetails.RenameDetection.DETAILED;
        }
        if (renameOption == 3) {
            return GitRepositoryDetails.RenameDetection.MOVES;
        }
        return GitRepositoryDetails.RenameDetection.NONE;
    }
}

