/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server.repositories;

import com.atlassian.fecru.gwt.admin.shared.repositories.AuthenticationOptions;
import com.atlassian.fisheye.spi.admin.data.AuthenticationData;
import com.atlassian.fisheye.spi.admin.data.AuthenticationStyle;
import org.apache.commons.lang.StringUtils;

public class AuthenticationDetailsServerBuilder {
    public AuthenticationOptions toClientType(AuthenticationData authData) {
        AuthenticationOptions authOptions = new AuthenticationOptions(com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle.NO_AUTH);
        if (authData != null) {
            switch (authData.getAuthenticationType()) {
                case SSH_KEY_WITH_PASSPHRASE: 
                case SSH_KEY_WITHOUT_PASSPHRASE: {
                    if (StringUtils.isNotEmpty((String)authData.getPublicKey())) {
                        authOptions.setStyle(com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle.GEN_SSH_KEY_PAIR);
                        authOptions.setPublicKey(authData.getPublicKey());
                    } else {
                        authOptions.setStyle(com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle.UPLOAD_PRIVATE_KEY_WITH_NO_PASSPHRASE);
                    }
                    authOptions.setKeyName(authData.getKeyName());
                    break;
                }
                case PASSWORD: {
                    authOptions.setStyle(com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle.PASSWORD);
                    authOptions.setWasPasswordInitiallySet(true);
                }
            }
        }
        return authOptions;
    }

    public AuthenticationData toServerType(AuthenticationOptions authOptions) {
        if (authOptions == null) {
            return null;
        }
        AuthenticationData authData = new AuthenticationData();
        switch (authOptions.getStyle()) {
            case GEN_SSH_KEY_PAIR: {
                authData.setPublicKey(authOptions.getPublicKey());
            }
            case UPLOAD_PRIVATE_KEY_WITH_NO_PASSPHRASE: {
                authData.setAuthenticationStyle(AuthenticationStyle.SSH_KEY_WITHOUT_PASSPHRASE);
                authData.setKeyName(authOptions.getKeyName());
                break;
            }
            case PASSWORD: {
                authData.setAuthenticationStyle(AuthenticationStyle.PASSWORD);
                authData.setPassword(authOptions.getPassword());
            }
        }
        return authData;
    }
}

