/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server;

import com.atlassian.crucible.scm.SCMModule;
import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.fecru.checkouturl.CheckoutURLAdminManager;
import com.atlassian.fecru.gwt.admin.client.RepositoryAdminRpcService;
import com.atlassian.fecru.gwt.admin.server.AdminRPCMethod;
import com.atlassian.fecru.gwt.admin.server.AdminRequestTracker;
import com.atlassian.fecru.gwt.admin.server.AdminService;
import com.atlassian.fecru.gwt.admin.server.ServerFieldValidationConstants;
import com.atlassian.fecru.gwt.admin.server.repositories.CvsRepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.ExternalAuthSettingsServerHelper;
import com.atlassian.fecru.gwt.admin.server.repositories.GitRepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.MercurialRepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.ObsoleteRepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.PerforceRepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.SvnRepositoryDetailsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.defaults.RepositoryOptionsServerBuilder;
import com.atlassian.fecru.gwt.admin.server.repositories.defaults.validation.AdvancedLinkerServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.defaults.validation.SimpleLinkerServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.AddRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.CvsRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.GitRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.MercurialRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.PerforceRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.RepositoryOptionsServerValidator;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.ServerValidationUtils;
import com.atlassian.fecru.gwt.admin.server.repositories.validation.SvnRepositoryServerValidator;
import com.atlassian.fecru.gwt.admin.shared.AuthorizationException;
import com.atlassian.fecru.gwt.admin.shared.InvalidRepositoryStateException;
import com.atlassian.fecru.gwt.admin.shared.NoSuchRepositoryException;
import com.atlassian.fecru.gwt.admin.shared.OperationFailureException;
import com.atlassian.fecru.gwt.admin.shared.auth.AuthenticationStyle;
import com.atlassian.fecru.gwt.admin.shared.auth.GwtSshKey;
import com.atlassian.fecru.gwt.admin.shared.repositories.AbstractLinker;
import com.atlassian.fecru.gwt.admin.shared.repositories.AdvancedLinker;
import com.atlassian.fecru.gwt.admin.shared.repositories.AllowProcessSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.AuthenticationOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.CaseAwarePathGlob;
import com.atlassian.fecru.gwt.admin.shared.repositories.CheckoutURLAttributes;
import com.atlassian.fecru.gwt.admin.shared.repositories.CvsRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.FullRepositoryInfo;
import com.atlassian.fecru.gwt.admin.shared.repositories.GitRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.LinkersSettings;
import com.atlassian.fecru.gwt.admin.shared.repositories.MercurialRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.ObsoleteRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.PerRepositoryOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.PerforceRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoriesSummary;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryAdminTabData;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryCharsets;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryConnectionTest;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryIndexingDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryInitData;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryKind;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryOperationalSummary;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryOptions;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositorySummary;
import com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryUpdate;
import com.atlassian.fecru.gwt.admin.shared.repositories.ScmPlugin;
import com.atlassian.fecru.gwt.admin.shared.repositories.ScmPluginRepositorySummary;
import com.atlassian.fecru.gwt.admin.shared.repositories.SimpleLinker;
import com.atlassian.fecru.gwt.admin.shared.repositories.SvnPathDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.SvnRepositoryDetails;
import com.atlassian.fecru.gwt.admin.shared.repositories.SvnSymbolicRules;
import com.atlassian.fecru.gwt.admin.shared.repositories.SymbolicRule;
import com.atlassian.fecru.gwt.admin.shared.repositories.defaults.validation.AdvancedLinkerClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.defaults.validation.SimpleLinkerClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.CvsRepositoryClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.FieldValidationConstants;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.GitRepositoryClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.MercurialRepositoryClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.PerforceRepositoryClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.RepositoryClientValidator;
import com.atlassian.fecru.gwt.admin.shared.repositories.validation.SvnRepositoryClientValidator;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationException;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidationMessages;
import com.atlassian.fecru.gwt.admin.shared.validation.Validator;
import com.atlassian.fecru.gwt.admin.shared.validation.ValidatorChain;
import com.atlassian.fecru.gwt.webitems.client.WebItem;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fisheye.scm.SCMModuleManager;
import com.atlassian.fisheye.spi.admin.data.AuthenticationData;
import com.atlassian.fisheye.spi.admin.data.CvsRepositoryData;
import com.atlassian.fisheye.spi.admin.data.DefaultRepositoryOptions;
import com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.GitRepositoryData;
import com.atlassian.fisheye.spi.admin.data.HgRepositoryData;
import com.atlassian.fisheye.spi.admin.data.KeyPair;
import com.atlassian.fisheye.spi.admin.data.ObsoleteRepositoryData;
import com.atlassian.fisheye.spi.admin.data.P4RepositoryData;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.data.RepositoryIndexingStatus;
import com.atlassian.fisheye.spi.admin.data.RepositoryState;
import com.atlassian.fisheye.spi.admin.data.RepositoryUpdateResult;
import com.atlassian.fisheye.spi.admin.data.SvnRepositoryData;
import com.atlassian.fisheye.spi.admin.data.UpdateOptions;
import com.atlassian.fisheye.spi.admin.services.CvsRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.services.P4RepositoryIndexer;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;
import com.atlassian.fisheye.spi.admin.services.RepositoryConfigException;
import com.atlassian.fisheye.spi.admin.services.RepositoryIndexer;
import com.atlassian.fisheye.spi.admin.services.SvnRepositoryIndexer;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4ScmConfig;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.activity.ActivityLog;
import com.cenqua.fisheye.svn.SvnConstants;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.admin.actions.HtmlTesterLayout;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import com.cenqua.fisheye.web.webfragments.WebFragmentDataFactory;
import com.cenqua.fisheye.web.webfragments.WebItemData;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="RepositoryAdminRpcService")
public class RepositoryAdminRpcServiceImpl
implements RepositoryAdminRpcService,
AdminService {
    private static final long RESTART_WAIT_TIMEOUT = 5000L;
    private static final Comparator<RepositorySummary> REPO_NAME_COMPARATOR = new Comparator<RepositorySummary>(){

        @Override
        public int compare(RepositorySummary o1, RepositorySummary o2) {
            return o1.getName().toLowerCase(Locale.US).compareTo(o2.getName().toLowerCase(Locale.US));
        }
    };
    private static final Comparator<ScmPlugin> SCM_MODULE_COMPARATOR = new Comparator<ScmPlugin>(){

        @Override
        public int compare(ScmPlugin o1, ScmPlugin o2) {
            int comparison = o2.getRepositories().size() - o1.getRepositories().size();
            if (comparison == 0) {
                comparison = o1.getName().toLowerCase(Locale.US).compareTo(o2.getName().toLowerCase(Locale.US));
            }
            return comparison;
        }
    };
    private final RepositoryManager repositoryManager;
    private final CheckoutURLAdminManager checkoutUrlAdminManager;
    private final RootConfig rootConfig;
    private final AdminRequestTracker adminRequestTracker;
    private final RepositoryAdminService repoAdminService;
    private final SCMModuleManager moduleManager;
    private final SshKeyManager sshKeyManager;
    private final FieldValidationConstants validationConstants;
    private final Validator<RepositoryDetails>[] addRepositoryValidators;
    private final Validator<RepositoryDetails>[] updateRepositoryValidators;

    @Autowired
    public RepositoryAdminRpcServiceImpl(RootConfig rootConfig, AdminRequestTracker adminRequestTracker, RepositoryAdminService repoAdminService, SCMModuleManager moduleManager, SshKeyManager sshKeyManager, RepositoryManager repositoryManager, CheckoutURLAdminManager checkoutUrlAdminManager) {
        this.rootConfig = rootConfig;
        this.adminRequestTracker = adminRequestTracker;
        this.repoAdminService = repoAdminService;
        this.moduleManager = moduleManager;
        this.sshKeyManager = sshKeyManager;
        this.repositoryManager = repositoryManager;
        this.checkoutUrlAdminManager = checkoutUrlAdminManager;
        this.validationConstants = ServerFieldValidationConstants.newInstance();
        this.updateRepositoryValidators = new Validator[]{new RepositoryClientValidator(this.validationConstants), new CvsRepositoryClientValidator(this.validationConstants), new SvnRepositoryClientValidator(this.validationConstants), new GitRepositoryClientValidator(this.validationConstants), new MercurialRepositoryClientValidator(this.validationConstants), new PerforceRepositoryClientValidator(this.validationConstants), new CvsRepositoryServerValidator(), new SvnRepositoryServerValidator(), new GitRepositoryServerValidator(sshKeyManager), new PerforceRepositoryServerValidator(), new MercurialRepositoryServerValidator(sshKeyManager)};
        this.addRepositoryValidators = new Validator[]{new RepositoryClientValidator(this.validationConstants), new CvsRepositoryClientValidator(this.validationConstants), new SvnRepositoryClientValidator(this.validationConstants), new GitRepositoryClientValidator(this.validationConstants), new MercurialRepositoryClientValidator(this.validationConstants), new PerforceRepositoryClientValidator(this.validationConstants), new AddRepositoryServerValidator(repoAdminService), new CvsRepositoryServerValidator(), new SvnRepositoryServerValidator(), new GitRepositoryServerValidator(sshKeyManager), new PerforceRepositoryServerValidator(), new MercurialRepositoryServerValidator(sshKeyManager)};
    }

    @Override
    @AdminRPCMethod
    public List<RepositorySummary> getRepositoriesDetails(List<RepositorySummary> summaries) {
        for (RepositorySummary summary : summaries) {
            this.resolveRepositoryDetails(summary);
        }
        return summaries;
    }

    @Override
    public CheckoutURLAttributes getDefaultCheckoutURL(RepositoryDetails details) {
        return new CheckoutURLAttributes(this.checkoutUrlAdminManager.getDefaultCheckoutUrl(this.detailsToData(details)));
    }

    @Override
    @AdminRPCMethod
    public String getStashTabHtml() {
        List<String> webFragments = WebFragmentDataFactory.getWebPanels(TotalityFilter.getRequest(), TotalityFilter.getResponse(), "admin.repositories.stash.tab");
        if (webFragments == null || webFragments.isEmpty()) {
            return null;
        }
        StringBuffer s2 = new StringBuffer();
        for (String fragment : webFragments) {
            s2.append(fragment);
        }
        return s2.toString();
    }

    @Override
    @AdminRPCMethod
    public List<RepositoryAdminTabData> getRepositoryAdminTabs(String repoName) {
        return WebFragmentDataFactory.mapWebPanelDescriptorsForRepo(TotalityFilter.getRequest(), repoName, "system.admin.repository.tab", new ErrorHandlingContextFunction(){

            @Override
            public RepositoryAdminTabData apply(WebPanelModuleDescriptor item, Map<String, Object> context) {
                if (item.getWebLabel() == null) {
                    throw new RuntimeException("Web panel " + item.getCompleteKey() + " must have a label.");
                }
                return new RepositoryAdminTabData(item.getKey(), item.getWebLabel().getDisplayableLabel(TotalityFilter.getRequest(), context), ((WebPanel)item.getModule()).getHtml(context));
            }
        });
    }

    @Override
    @AdminRPCMethod
    public List<RepositoryAdminTabData> getRepositoryAdminDefaultTabs() {
        return WebFragmentDataFactory.mapWebPanelDescriptors(TotalityFilter.getRequest(), "system.admin.repositories.defaults.tab", new ErrorHandlingContextFunction(){

            @Override
            public RepositoryAdminTabData apply(WebPanelModuleDescriptor item, Map<String, Object> context) {
                if (item.getWebLabel() == null) {
                    throw new RuntimeException("Web panel " + item.getCompleteKey() + " must have a label.");
                }
                return new RepositoryAdminTabData(item.getKey(), item.getWebLabel().getDisplayableLabel(TotalityFilter.getRequest(), context), ((WebPanel)item.getModule()).getHtml(context));
            }
        });
    }

    private void resolveRepositoryDetails(RepositorySummary summary) {
        if (!summary.isResolvedDetails()) {
            RepositoryData repo = this.repoAdminService.getRepositoryData(summary.getName());
            summary.setOperationalSummary(this.toRepoOperationalSummary(repo, true));
            summary.setWebItems(this.webItemsFor(repo.getName()));
            summary.setResolvedDetails(true);
        }
    }

    @Override
    @AdminRPCMethod
    public RepositoriesSummary getRepositoriesSummary() throws AuthorizationException {
        Set repos = this.repoAdminService.getRepositories();
        ArrayList<RepositorySummary> outRepos = new ArrayList<RepositorySummary>(repos.size());
        Logs.APP_LOG.debug((Object)("Fetching data for " + repos.size() + " repositories"));
        for (RepositoryData repo : repos) {
            outRepos.add(new RepositorySummary(this.toRepDetails(repo), repo.getLocationDescription(), this.toRepoOperationalSummary(repo, false), Collections.emptyList()));
        }
        Collections.sort(outRepos, REPO_NAME_COMPARATOR);
        Logs.APP_LOG.debug((Object)"Done fetching repository data");
        LinkedList<ScmPlugin> modules = new LinkedList<ScmPlugin>();
        for (SCMModule scmModule : this.moduleManager.getModules()) {
            if (scmModule.getModuleDescriptor().getPluginKey() == null) continue;
            modules.add(new ScmPlugin(scmModule.getName(), (String)scmModule.getModuleDescriptor().getPlugin().getPluginInformation().getParameters().get("configure.url"), this.listRepos(scmModule)));
        }
        Collections.sort(modules, SCM_MODULE_COMPARATOR);
        return new RepositoriesSummary(outRepos, modules);
    }

    private RepositoryDetails toRepDetails(RepositoryData repository) {
        return new RepositoryDetails(this.toRepoKind(repository), repository.getName(), repository.getDescription());
    }

    private RepositoryOperationalSummary toRepoOperationalSummary(RepositoryData repo, boolean detailed) {
        RepositoryOperationalSummary operationalSummary;
        boolean isEnabled = this.repoAdminService.isEnabled(repo.getName());
        if (isEnabled && detailed) {
            RepositoryIndexer indexer = this.repoAdminService.getIndexer(repo.getName());
            RepositoryIndexingStatus indexingStatus = indexer != null ? indexer.getIndexingStatus() : null;
            RepositoryStatus status = this.repositoryManager.getRepository(repo.getName()).getStatus();
            com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryState state = this.repoStateFor(repo, isEnabled);
            operationalSummary = new RepositoryOperationalSummary(state, this.messageFor(status), status.getEngineErrors(), this.pipelineStateFor(status), this.lastIndexUpdate(indexingStatus), this.indexingDetailsFor(indexingStatus), this.recentActivityFor(status), status.isInitialScanningComplete() ? status.getCompletedScanningWork() : status.getTotalChangesets(), status.isInitialScanningComplete() ? status.getCompletedScanningWork() * 4 : status.getTotalIndexingWork(), status.getCompletedIndexingWork(), status.getCompletedScanningWork(), this.repoAdminService.isPipelined(repo.getName()), status.isUpgrading(), !status.isActive() && state == com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryState.RUNNING, status.isInitialScanningComplete(), status.isInitialIndexingComplete(), status.isPollingDisabled(), status.isPaused(), status.getPauseEndSeconds());
        } else {
            operationalSummary = new RepositoryOperationalSummary(isEnabled, this.repoStateFor(repo, isEnabled));
        }
        operationalSummary.setObsolete(repo.isObsolete());
        return operationalSummary;
    }

    private Map<RepositoryOperationalSummary.ProcessingState, Integer> pipelineStateFor(RepositoryStatus status) {
        TreeMap<RepositoryOperationalSummary.ProcessingState, Integer> results = new TreeMap<RepositoryOperationalSummary.ProcessingState, Integer>();
        for (Map.Entry entry : status.getIndexingStateCounts().entrySet()) {
            if (entry.getKey() == ChangeSetIndexingState.UNKNOWN) continue;
            results.put(RepositoryOperationalSummary.ProcessingState.valueOf(((ChangeSetIndexingState)((Object)entry.getKey())).name()), ((AtomicInteger)entry.getValue()).intValue());
        }
        TreeMap<RepositoryOperationalSummary.ProcessingState, Integer> totals = new TreeMap<RepositoryOperationalSummary.ProcessingState, Integer>();
        for (RepositoryOperationalSummary.ProcessingState state : RepositoryOperationalSummary.ProcessingState.values()) {
            int total = 0;
            for (RepositoryOperationalSummary.ProcessingState part : Arrays.asList(RepositoryOperationalSummary.ProcessingState.values()).subList(state.ordinal(), RepositoryOperationalSummary.ProcessingState.values().length)) {
                total += ((Integer)results.get((Object)part)).intValue();
            }
            totals.put(state, total);
        }
        return totals;
    }

    private List<com.atlassian.fecru.gwt.admin.shared.repositories.ActivityLog> recentActivityFor(RepositoryStatus status) {
        LinkedList<com.atlassian.fecru.gwt.admin.shared.repositories.ActivityLog> recentActivity = new LinkedList<com.atlassian.fecru.gwt.admin.shared.repositories.ActivityLog>();
        for (ActivityLog log : status.getRecentActivities().getAllItems()) {
            recentActivity.add(new com.atlassian.fecru.gwt.admin.shared.repositories.ActivityLog(log.getActivity(), log.getStartTime(), log.getDuration()));
        }
        return recentActivity;
    }

    @Override
    @AdminRPCMethod
    public void startRepository(String name) throws InvalidRepositoryStateException, AuthorizationException, OperationFailureException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoEnabledState(name, true);
        this.ensureRepoInRightState(name, this.repoAdminService.getState(name), "starting", RepositoryState.STOPPED);
        try {
            this.repoAdminService.start(name);
        }
        catch (RepositoryConfigException e2) {
            throw new OperationFailureException(this.generateMsgAndLogRepoActionFailure(name, "start", (Exception)((Object)e2)));
        }
    }

    @Override
    @AdminRPCMethod
    public void stopRepository(String name) throws InvalidRepositoryStateException, AuthorizationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoEnabledState(name, true);
        this.ensureRepoInRightState(name, this.repoAdminService.getState(name), "stopping", RepositoryState.RUNNING);
        this.repoAdminService.stop(name);
    }

    @Override
    @AdminRPCMethod
    public void restartRepository(String name) throws InvalidRepositoryStateException, AuthorizationException, OperationFailureException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoEnabledState(name, true);
        this.ensureRepoInRightState(name, this.repoAdminService.getState(name), "restarting", RepositoryState.RUNNING);
        if (this.repoAdminService.stopAndWait(name, 5000L) != RepositoryState.STOPPED) {
            throw new OperationFailureException("Repository took too long to stop, you may need to start it manually.");
        }
        try {
            this.repoAdminService.start(name);
        }
        catch (RepositoryConfigException e2) {
            throw new OperationFailureException(this.generateMsgAndLogRepoActionFailure(name, "restart", (Exception)((Object)e2)));
        }
    }

    @Override
    @AdminRPCMethod
    public void enableRepository(String name, boolean enable) throws InvalidRepositoryStateException, AuthorizationException, OperationFailureException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoEnabledState(name, !enable);
        if (!enable) {
            this.ensureRepoInRightState(name, this.repoAdminService.getState(name), "disabling", RepositoryState.STOPPED);
        }
        try {
            if (enable) {
                this.repoAdminService.enable(name);
            } else {
                this.repoAdminService.disable(name);
            }
        }
        catch (RepositoryConfigException e2) {
            throw new OperationFailureException(this.generateMsgAndLogRepoActionFailure(name, "enable", (Exception)((Object)e2)));
        }
    }

    @Override
    @AdminRPCMethod
    public void deleteRepository(String name) throws InvalidRepositoryStateException, AuthorizationException, OperationFailureException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        if (this.repoAdminService.isEnabled(name)) {
            this.ensureRepoInRightState(name, this.repoAdminService.getState(name), "deleting", RepositoryState.STOPPED);
        }
        try {
            this.repoAdminService.delete(name);
        }
        catch (RepositoryConfigException e2) {
            throw new OperationFailureException(this.generateMsgAndLogRepoActionFailure(name, "delete", (Exception)((Object)e2)));
        }
    }

    @Override
    @AdminRPCMethod
    public RepositoryInitData getRepositoryInitData() throws AuthorizationException {
        return new RepositoryInitData(this.getRepositoryCharsets(), this.checkoutUrlAdminManager.getDefaultShowCheckoutUrl());
    }

    @Override
    @AdminRPCMethod
    public RepositoryCharsets getRepositoryCharsets() throws AuthorizationException {
        return new RepositoryCharsets(Charset.availableCharsets().keySet(), CvsScmConfig.DEFAULT_CVS_ENCODING.name(), SvnConstants.DEFAULT_SVN_ENCODING.name(), P4ScmConfig.DEFAULT_ENCODING);
    }

    protected PerRepositoryOptions.AuthAvailable getAuthAvailable() {
        if (this.rootConfig.getConfig().isSetSecurity() && this.rootConfig.getConfig().getSecurity().isSetCustom()) {
            return PerRepositoryOptions.AuthAvailable.CUSTOM;
        }
        return null;
    }

    private void updateAuthenticationDataFromHttpSession(AuthenticationData authData) {
        if (StringUtils.isNotEmpty((String)authData.getKeyName())) {
            Pair<String, String> keypair = this.loadKeyFromSession(authData.getKeyName());
            authData.setPublicKey(keypair.getFirst());
            authData.setPrivateKey(keypair.getSecond());
        }
    }

    RepositoryData detailsToData(final RepositoryDetails details) {
        return details.getKind().map(new RepositoryKind.Mapper<RepositoryData>(){

            @Override
            public RepositoryData forCvs() {
                return new CvsRepositoryDetailsServerBuilder().toServerType((CvsRepositoryDetails)details);
            }

            @Override
            public RepositoryData forGit() {
                GitRepositoryData gitRepData = new GitRepositoryDetailsServerBuilder().toServerType((GitRepositoryDetails)details);
                RepositoryAdminRpcServiceImpl.this.updateAuthenticationDataFromHttpSession(gitRepData.getAuthentication());
                return gitRepData;
            }

            @Override
            public RepositoryData forSubversion() {
                return new SvnRepositoryDetailsServerBuilder().toServerType((SvnRepositoryDetails)details);
            }

            @Override
            public RepositoryData forPerforce() {
                return new PerforceRepositoryDetailsServerBuilder().toServerType((PerforceRepositoryDetails)details);
            }

            @Override
            public RepositoryData forDisabled() {
                return new ObsoleteRepositoryDetailsServerBuilder().toServerType((ObsoleteRepositoryDetails)details);
            }

            @Override
            public RepositoryData forMercurial() {
                HgRepositoryData hgRepData = new MercurialRepositoryDetailsServerBuilder().toServerType((MercurialRepositoryDetails)details);
                RepositoryAdminRpcServiceImpl.this.updateAuthenticationDataFromHttpSession(hgRepData.getAuthentication());
                return hgRepData;
            }
        });
    }

    @Override
    @AdminRPCMethod
    public void createRepository(final RepositoryDetails details, boolean enableImmediately, Boolean showCheckoutURL, CheckoutURLAttributes checkoutURLAttributes) throws AuthorizationException, OperationFailureException, ValidationException {
        ValidatorChain.validateAndThrowIfNotEmpty(details, this.addRepositoryValidators);
        try {
            RepositoryData repoData = details.getKind().map(new RepositoryKind.Mapper<RepositoryData>(){

                @Override
                public RepositoryData forCvs() {
                    return new CvsRepositoryDetailsServerBuilder().toServerType((CvsRepositoryDetails)details);
                }

                @Override
                public RepositoryData forGit() {
                    GitRepositoryData gitRepData = new GitRepositoryDetailsServerBuilder().toServerType((GitRepositoryDetails)details);
                    RepositoryAdminRpcServiceImpl.this.updateAuthenticationDataFromHttpSession(gitRepData.getAuthentication());
                    return gitRepData;
                }

                @Override
                public RepositoryData forSubversion() {
                    return new SvnRepositoryDetailsServerBuilder().toServerType((SvnRepositoryDetails)details);
                }

                @Override
                public RepositoryData forPerforce() {
                    return new PerforceRepositoryDetailsServerBuilder().toServerType((PerforceRepositoryDetails)details);
                }

                @Override
                public RepositoryData forDisabled() {
                    return null;
                }

                @Override
                public RepositoryData forMercurial() {
                    HgRepositoryData hgRepData = new MercurialRepositoryDetailsServerBuilder().toServerType((MercurialRepositoryDetails)details);
                    RepositoryAdminRpcServiceImpl.this.updateAuthenticationDataFromHttpSession(hgRepData.getAuthentication());
                    return hgRepData;
                }
            });
            if (repoData != null) {
                repoData.setEnabled(Boolean.valueOf(enableImmediately));
                this.repoAdminService.create(repoData);
                com.atlassian.fisheye.spi.admin.data.RepositoryOptions options = this.repoAdminService.getRepositoryOptions(repoData.getName());
                options.setShowCheckoutURL(showCheckoutURL);
                options.setCheckoutURL(checkoutURLAttributes.toMap());
                this.repoAdminService.setRepositoryOptions(repoData.getName(), options);
            }
        }
        catch (RepositoryConfigException e2) {
            throw new OperationFailureException(this.generateMsgAndLogRepoActionFailure(details.getName(), "create", (Exception)((Object)e2)));
        }
        try {
            if (enableImmediately) {
                this.repoAdminService.start(details.getName());
            }
        }
        catch (Exception e3) {
            throw new OperationFailureException(this.generateMsgAndLogRepoActionFailure(details.getName(), "start new", e3));
        }
    }

    @Override
    @AdminRPCMethod
    public ValidationMessages validateNewRepository(RepositoryDetails details) throws AuthorizationException {
        return ValidatorChain.validate(details, this.addRepositoryValidators);
    }

    @Override
    @AdminRPCMethod
    public SvnPathDetails analyseSvnPath(String testPath, boolean useAutoRules, SvnSymbolicRules customRules) throws AuthorizationException, OperationFailureException {
        SvnSymbolicType svnSymbolic = null;
        if (useAutoRules || customRules != null) {
            svnSymbolic = SvnSymbolicType.Factory.newInstance();
            svnSymbolic.setAutoRules(useAutoRules);
            if (customRules != null) {
                for (SymbolicRule rule : customRules.getTrunkRules()) {
                    this.copy(rule, svnSymbolic.addNewTrunk());
                }
                for (SymbolicRule rule : customRules.getBranchRules()) {
                    this.copy(rule, svnSymbolic.addNewBranch());
                }
                for (SymbolicRule rule : customRules.getTagRules()) {
                    this.copy(rule, svnSymbolic.addNewTag());
                }
            }
        }
        try {
            SvnLogicalPathMatcher matcher = new SvnLogicalPathMatcher(svnSymbolic);
            Path path = new Path(testPath);
            SvnPathDetails pathDetails = new SvnPathDetails();
            pathDetails.setContainerId(matcher.getContainerId(path));
            Path logical = matcher.getLogicalPath(path);
            if (logical == null) {
                pathDetails.setLogicalPath("No Logical Path");
                pathDetails.setLogicalTail("");
            } else {
                pathDetails.setLogicalPath(matcher.getLogicalPath(path).getPath());
                pathDetails.setLogicalTail(matcher.getLogicalTail(path).getPath());
            }
            return pathDetails;
        }
        catch (ConfigException e2) {
            throw new OperationFailureException(e2);
        }
    }

    @Override
    @AdminRPCMethod
    public FullRepositoryInfo getFullRepositoryInfo(String name) throws AuthorizationException, OperationFailureException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        try {
            RepositoryData repo = this.repoAdminService.getRepositoryData(name);
            return new FullRepositoryInfo(this.toRepoDetails(repo), this.toPerRepoOptions(repo), this.getRepositoryDefaults(), this.toRepoOperationalSummary(repo, true), this.webItemsFor(name));
        }
        catch (DbException e2) {
            throw new OperationFailureException(e2);
        }
        catch (IOException e3) {
            throw new OperationFailureException(e3);
        }
    }

    @Override
    @AdminRPCMethod
    public RepositoryOperationalSummary getRepositoryOperationalSummary(String name) throws AuthorizationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        return this.toRepoOperationalSummary(this.repoAdminService.getRepositoryData(name), true);
    }

    @Override
    @AdminRPCMethod
    public RepositoryOptions getRepositoryDefaults() throws AuthorizationException, OperationFailureException {
        try {
            DefaultRepositoryOptions defaultOptions = this.repoAdminService.getDefaultOptions();
            return new RepositoryOptions(new LinkersSettings(RepositoryOptionsServerBuilder.toSimpleLinkersClientType(defaultOptions.getSimpleLinkers()), RepositoryOptionsServerBuilder.toAdvancedLinkersClientType(defaultOptions.getAdvancedLinkers())), defaultOptions.isAllowAnon(), defaultOptions.isAllowLoggedUsers(), RepositoryOptionsServerBuilder.toGroupsSecuritiesClientType(defaultOptions.getRequiredGroups()), new AllowProcessSettings(RepositoryOptionsServerBuilder.pathToClientType(defaultOptions.getAllowIncludes()), RepositoryOptionsServerBuilder.globToClientType(defaultOptions.getAllowExcludes())), RepositoryOptionsServerBuilder.toHiddenDirsClientType(defaultOptions.getHiddenDirectories()), RepositoryOptionsServerBuilder.toTarballSettingsClientType(defaultOptions.getTarballSettings()), RepositoryOptionsServerBuilder.toUpdateOptionsClientType((UpdateOptions)defaultOptions.getUpdateOptions()), RepositoryOptionsServerBuilder.toCommitMessageSyntaxSettingsClientType(defaultOptions.getCommitMessageSyntaxSettings()), defaultOptions.isChangesetDiscussionsEnabled(), defaultOptions.isWatchesEnabled(), defaultOptions.getMaxIndexableSize(), defaultOptions.getShowCheckoutURLs());
        }
        catch (DbException e2) {
            throw new OperationFailureException(e2);
        }
    }

    @Override
    @AdminRPCMethod
    public void setRepositoryDefaults(RepositoryOptions defaults) throws AuthorizationException, OperationFailureException, ValidationException {
        Validator.Utils.validateAndThrowIfNonEmpty(defaults, new RepositoryOptionsServerValidator("repositoryDefaults."));
        try {
            DefaultRepositoryOptions defaultOptions = this.repoAdminService.getDefaultOptions();
            defaultOptions.setSimpleLinkers(RepositoryOptionsServerBuilder.toSimpleLinkersServerType(defaults.getLinkersSettings().getSimpleLinkers()));
            defaultOptions.setAdvancedLinkers(RepositoryOptionsServerBuilder.toAdvancedLinkersServerType(defaults.getLinkersSettings().getAdvancedLinkers()));
            defaultOptions.setAllowAnon(defaults.isAllowAnonymousAccess());
            defaultOptions.setAllowLoggedUsers(defaults.isAllowLoggedUsersAccess());
            defaultOptions.setRequiredGroups(RepositoryOptionsServerBuilder.toGroups(defaults.getGroupPermissions()));
            defaultOptions.setAllowIncludes(RepositoryOptionsServerBuilder.toCaseAwarePathsServerType(defaults.getAllowProcessSettings().getIncludes()));
            defaultOptions.setAllowExcludes(RepositoryOptionsServerBuilder.toCaseAwarePathGlobsServerType(defaults.getAllowProcessSettings().getExcludes()));
            defaultOptions.setHiddenDirectories(RepositoryOptionsServerBuilder.toCaseAwarePathsServerType(defaults.getHiddenDirsSettings().getDirs()));
            defaultOptions.setTarballSettings(RepositoryOptionsServerBuilder.toTarballSettingsServerType(defaults.getTarballsSettings()));
            defaultOptions.setCommitMessageSyntaxSettings(RepositoryOptionsServerBuilder.toCommitMessageSyntaxServerType(defaults.getCommitMessageSyntaxSettings()));
            defaultOptions.setChangesetDiscussionsEnabled(defaults.isAllowChangesetDiscussion().booleanValue());
            defaultOptions.setWatchesEnabled(defaults.isWatchersEnabled().booleanValue());
            defaultOptions.setMaxIndexableSize(defaults.getMaxIndexableSize());
            defaultOptions.setUpdateOptions((DefaultUpdateOptions)RepositoryOptionsServerBuilder.toUpdateOptionsServerType(defaults.getUpdateOptions()));
            defaultOptions.setShowCheckoutURLs(defaults.getShowCheckoutURLs());
            this.repoAdminService.setDefaultOptions(defaultOptions);
        }
        catch (RepositoryConfigException e2) {
            throw new OperationFailureException(e2);
        }
    }

    @Override
    @AdminRPCMethod
    public ValidationMessages validateLinker(AbstractLinker linker) throws AuthorizationException {
        if (linker instanceof SimpleLinker) {
            return ValidatorChain.validate((SimpleLinker)linker, new SimpleLinkerClientValidator(""), new SimpleLinkerServerValidator());
        }
        return ValidatorChain.validate((AdvancedLinker)linker, new AdvancedLinkerClientValidator(""), new AdvancedLinkerServerValidator());
    }

    @Override
    @AdminRPCMethod
    public ValidationMessages validateGlob(CaseAwarePathGlob glob) throws AuthorizationException {
        return ServerValidationUtils.validateGlob(glob.getGlob(), "pattern", "You must enter a pattern", new ValidationMessages());
    }

    @Override
    @AdminRPCMethod
    public void performIncrementalIndex(String name) throws AuthorizationException, OperationFailureException, InvalidRepositoryStateException, ValidationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoIsStarted(name, "Incremental index");
        Disposer.pushThreadInstance();
        try {
            this.repoAdminService.getIndexer(name).startIncrementalIndexing();
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    @Override
    @AdminRPCMethod
    public void performLineCountReindex(String name) throws AuthorizationException, OperationFailureException, InvalidRepositoryStateException, ValidationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoIsStarted(name, "Line count reindex");
        Disposer.pushThreadInstance();
        try {
            this.repoAdminService.getIndexer(name).startLineCountReindexing();
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    @Override
    @AdminRPCMethod
    public void performFullReindex(String name) throws AuthorizationException, OperationFailureException, InvalidRepositoryStateException, ValidationException, NoSuchRepositoryException {
        this.performFullReindex(name, false);
    }

    @Override
    @AdminRPCMethod
    public void performFullReindex(String name, boolean reclone) throws AuthorizationException, OperationFailureException, InvalidRepositoryStateException, ValidationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        try {
            this.repoAdminService.fullReindex(name, reclone);
        }
        catch (RepositoryConfigException e2) {
            Logs.APP_LOG.warn((Object)("Problem starting a full reindex on repository " + name), (Throwable)e2);
        }
        catch (TimeoutException e3) {
            Logs.APP_LOG.warn((Object)("Timed out waiting for the repository " + name + " to stop"), (Throwable)e3);
        }
    }

    @Override
    @AdminRPCMethod
    public void performCrucibleReindex(String name) throws AuthorizationException, OperationFailureException, InvalidRepositoryStateException, ValidationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoIsStarted(name, "Crucible reindex");
        Disposer.pushThreadInstance();
        try {
            this.repositoryManager.getRepository(name).requestCrucibleReindex();
        }
        catch (RepositoryHandle.StateException e2) {
            throw new IllegalStateException((Throwable)((Object)e2));
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    @Override
    @AdminRPCMethod
    public void performCvsFullScan(String name) throws AuthorizationException, OperationFailureException, InvalidRepositoryStateException, ValidationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoIsA(name, RepositoryKind.CVS);
        this.ensureRepoEnabledState(name, true);
        Disposer.pushThreadInstance();
        try {
            ((CvsRepositoryIndexer)this.repoAdminService.getIndexer(name)).startFullScan();
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AdminRPCMethod
    public void performSvnRevisionPropReindex(String name, long fromRevision, long toRevision) throws AuthorizationException, OperationFailureException, InvalidRepositoryStateException, ValidationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoEnabledState(name, true);
        this.ensureRepoInRightState(name, this.repoAdminService.getState(name), "reindex SVN revision properties", RepositoryState.RUNNING);
        this.ensureRepoIsA(name, RepositoryKind.SUBVERSION);
        Disposer.pushThreadInstance();
        try {
            ((SvnRepositoryIndexer)this.repoAdminService.getIndexer(name)).startRevisionPropertiesReindexing(fromRevision, toRevision);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    @Override
    @AdminRPCMethod
    public void performChangesetCommentReindex(final String repositoryName) throws NoSuchRepositoryException, InvalidRepositoryStateException {
        this.ensureRepoExists(repositoryName);
        this.ensureRepoEnabledState(repositoryName, true);
        this.ensureRepoInRightState(repositoryName, this.repoAdminService.getState(repositoryName), "reindex changeset discussions", RepositoryState.RUNNING);
        Disposer.with(new Runnable(){

            @Override
            public void run() {
                RepositoryAdminRpcServiceImpl.this.repoAdminService.getIndexer(repositoryName).startChangesetCommentReindexing();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AdminRPCMethod
    public void performPerforceChangelistReindex(String name, long fromRevision, long toRevision) throws AuthorizationException, OperationFailureException, InvalidRepositoryStateException, ValidationException, NoSuchRepositoryException {
        this.ensureRepoExists(name);
        this.ensureRepoEnabledState(name, true);
        this.ensureRepoInRightState(name, this.repoAdminService.getState(name), "reindex Perforce changelists", RepositoryState.RUNNING);
        this.ensureRepoIsA(name, RepositoryKind.PERFORCE);
        Disposer.pushThreadInstance();
        try {
            ((P4RepositoryIndexer)this.repoAdminService.getIndexer(name)).startChangelistReindexing(fromRevision, toRevision);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    @Override
    @AdminRPCMethod
    public RepositoryUpdate updateRepository(final RepositoryDetails details, PerRepositoryOptions options) throws AuthorizationException, OperationFailureException, ValidationException, NoSuchRepositoryException {
        this.ensureRepoExists(details.getName());
        ValidatorChain.validateAndThrowIfNotEmpty(details, this.updateRepositoryValidators);
        Validator.Utils.validateAndThrowIfNonEmpty(options, new RepositoryOptionsServerValidator("repositoryOptions."));
        com.atlassian.fisheye.spi.admin.data.RepositoryOptions repositoryOptions = this.toRepositoryOptions(details, options);
        try {
            RepositoryUpdateResult updateResult = details.getKind().map(new RepositoryKind.Mapper<RepoAction>(){

                @Override
                public RepoAction forCvs() {
                    return new RepoAction(){

                        @Override
                        public RepositoryUpdateResult update() throws RepositoryConfigException {
                            return RepositoryAdminRpcServiceImpl.this.repoAdminService.update((RepositoryData)new CvsRepositoryDetailsServerBuilder().toServerType((CvsRepositoryDetails)details));
                        }
                    };
                }

                @Override
                public RepoAction forGit() {
                    return new RepoAction(){

                        @Override
                        public RepositoryUpdateResult update() throws RepositoryConfigException {
                            GitRepositoryData gitRepData = new GitRepositoryDetailsServerBuilder().toServerType((GitRepositoryDetails)details);
                            RepositoryAdminRpcServiceImpl.this.updateAuthenticationDataFromHttpSession(gitRepData.getAuthentication());
                            return RepositoryAdminRpcServiceImpl.this.repoAdminService.update((RepositoryData)gitRepData);
                        }
                    };
                }

                @Override
                public RepoAction forSubversion() {
                    return new RepoAction(){

                        @Override
                        public RepositoryUpdateResult update() throws RepositoryConfigException {
                            SvnRepositoryDetails repoDetails = (SvnRepositoryDetails)details;
                            SvnRepositoryData repo = (SvnRepositoryData)RepositoryAdminRpcServiceImpl.this.repoAdminService.getRepositoryData(repoDetails.getName());
                            if (!repoDetails.getShouldUpdatePassword()) {
                                repoDetails.setPassword(repo.getPassword());
                            }
                            return RepositoryAdminRpcServiceImpl.this.repoAdminService.update((RepositoryData)new SvnRepositoryDetailsServerBuilder().toServerType(repoDetails));
                        }
                    };
                }

                @Override
                public RepoAction forPerforce() {
                    return new RepoAction(){

                        @Override
                        public RepositoryUpdateResult update() throws RepositoryConfigException {
                            PerforceRepositoryDetails repoDetails = (PerforceRepositoryDetails)details;
                            P4RepositoryData repo = (P4RepositoryData)RepositoryAdminRpcServiceImpl.this.repoAdminService.getRepositoryData(repoDetails.getName());
                            if (!repoDetails.getShouldUpdatePassword()) {
                                repoDetails.setPassword(repo.getPassword());
                            }
                            return RepositoryAdminRpcServiceImpl.this.repoAdminService.update((RepositoryData)new PerforceRepositoryDetailsServerBuilder().toServerType(repoDetails));
                        }
                    };
                }

                @Override
                public RepoAction forDisabled() {
                    return new RepoAction(){

                        @Override
                        public RepositoryUpdateResult update() throws RepositoryConfigException {
                            return new RepositoryUpdateResult(false, false);
                        }
                    };
                }

                @Override
                public RepoAction forMercurial() {
                    return new RepoAction(){

                        @Override
                        public RepositoryUpdateResult update() throws RepositoryConfigException {
                            HgRepositoryData hgRepData = new MercurialRepositoryDetailsServerBuilder().toServerType((MercurialRepositoryDetails)details);
                            RepositoryAdminRpcServiceImpl.this.updateAuthenticationDataFromHttpSession(hgRepData.getAuthentication());
                            return RepositoryAdminRpcServiceImpl.this.repoAdminService.update((RepositoryData)hgRepData);
                        }
                    };
                }
            }).update();
            Pair<Boolean, Boolean> result = this.updateRepositoryOptions(details.getName(), repositoryOptions);
            return new RepositoryUpdate(updateResult.isReindexRequired() || result.getFirst() != false, updateResult.isRestartRequired() || result.getSecond() != false);
        }
        catch (RepositoryConfigException e2) {
            throw new OperationFailureException(this.generateMsgAndLogRepoActionFailure(details.getName(), "update", (Exception)((Object)e2)));
        }
    }

    private Pair<Boolean, Boolean> updateRepositoryOptions(String repoName, com.atlassian.fisheye.spi.admin.data.RepositoryOptions newOptions) throws RepositoryConfigException {
        Pair<Boolean, Boolean> result = this.checkRestartAndReindex(newOptions, this.repoAdminService.getRepositoryOptions(repoName));
        this.repoAdminService.setRepositoryOptions(repoName, newOptions);
        return result;
    }

    private Pair<Boolean, Boolean> checkRestartAndReindex(com.atlassian.fisheye.spi.admin.data.RepositoryOptions newOptions, com.atlassian.fisheye.spi.admin.data.RepositoryOptions oldOptions) {
        boolean allowExcludesSame = oldOptions.getAllowExcludes().equals(newOptions.getAllowExcludes());
        boolean allowIncludesSame = oldOptions.getAllowIncludes().equals(newOptions.getAllowIncludes());
        boolean hiddenDirSame = oldOptions.getHiddenDirectories().equals(newOptions.getHiddenDirectories());
        return Pair.newInstance(!allowExcludesSame || !allowIncludesSame, !hiddenDirSame);
    }

    private com.atlassian.fisheye.spi.admin.data.RepositoryOptions toRepositoryOptions(RepositoryDetails details, PerRepositoryOptions options) throws ValidationException, AuthorizationException {
        com.atlassian.fisheye.spi.admin.data.RepositoryOptions repositoryOptions = this.repoAdminService.getRepositoryOptions(details.getName());
        repositoryOptions.setSimpleLinkers(RepositoryOptionsServerBuilder.toSimpleLinkersServerType(options.getLinkersSettings().getSimpleLinkers()));
        repositoryOptions.setAdvancedLinkers(RepositoryOptionsServerBuilder.toAdvancedLinkersServerType(options.getLinkersSettings().getAdvancedLinkers()));
        repositoryOptions.setUsingDefaultsPermissions(options.isUsingDefaultsPermissions());
        repositoryOptions.setAllowAnon(options.isAllowAnonymousAccess());
        repositoryOptions.setAllowLoggedUsers(options.isAllowLoggedUsersAccess());
        repositoryOptions.setRequiredGroups(RepositoryOptionsServerBuilder.toGroups(options.getGroupPermissions()));
        repositoryOptions.setAllowIncludes(RepositoryOptionsServerBuilder.toCaseAwarePathsServerType(options.getAllowProcessSettings().getIncludes()));
        repositoryOptions.setAllowExcludes(RepositoryOptionsServerBuilder.toCaseAwarePathGlobsServerType(options.getAllowProcessSettings().getExcludes()));
        repositoryOptions.setHiddenDirectories(RepositoryOptionsServerBuilder.toCaseAwarePathsServerType(options.getHiddenDirsSettings().getDirs()));
        repositoryOptions.setTarballSettings(options.getTarballsSettings() != null ? RepositoryOptionsServerBuilder.toTarballSettingsServerType(options.getTarballsSettings()) : null);
        repositoryOptions.setCommitMessageSyntaxSettings(options.getCommitMessageSyntaxSettings() != null ? RepositoryOptionsServerBuilder.toCommitMessageSyntaxServerType(options.getCommitMessageSyntaxSettings()) : null);
        repositoryOptions.setChangesetDiscussionsEnabled(options.isAllowChangesetDiscussion());
        repositoryOptions.setWatchesEnabled(options.isWatchersEnabled());
        repositoryOptions.setExternalAuthSettings(ExternalAuthSettingsServerHelper.toExternalAuthSettingsServerType(options.getExternalAuthSettings()));
        repositoryOptions.setUpdateOptions(RepositoryOptionsServerBuilder.toUpdateOptionsServerType(options.getUpdateOptions()));
        repositoryOptions.setShowCheckoutURL(options.getShowCheckoutURLs());
        repositoryOptions.setCheckoutURL(options.getCheckoutURL().toMap());
        repositoryOptions.setMaxIndexableSize(options.getMaxIndexableSize());
        return repositoryOptions;
    }

    @Override
    @AdminRPCMethod
    public RepositoryConnectionTest testRepositoryConnection(final RepositoryDetails details) throws AuthorizationException, ValidationException {
        return this.testRepositoryConnection(new ConnectionTester(){

            @Override
            public void test() throws Exception {
                RepositoryAdminRpcServiceImpl.this.repoAdminService.testConnectionFor(RepositoryAdminRpcServiceImpl.this.detailsToData(details));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryConnectionTest testRepositoryConnection(ConnectionTester connectionTester) throws AuthorizationException, ValidationException {
        String ndc = "verify-connection-" + System.currentTimeMillis();
        HtmlTesterLayout layout = new HtmlTesterLayout(HtmlTesterLayout.getDefaultStyle(), ndc, true);
        StringWriter writer = new StringWriter();
        WriterAppender appender = new WriterAppender((Layout)layout, (Writer)writer);
        appender.setThreshold((Priority)Level.INFO);
        appender.setImmediateFlush(true);
        RepositoryConnectionTest test = new RepositoryConnectionTest();
        try {
            Logs.APP_LOG.addAppender((Appender)appender);
            NDC.push((String)ndc);
            connectionTester.test();
            Logs.APP_LOG.info((Object)"Connection succeeded.");
            test.setPass(true);
        }
        catch (IndexOutOfBoundsException e2) {
            Logs.APP_LOG.error((Object)"Connection failed.");
            test.setPass(false);
        }
        catch (Throwable e3) {
            Logs.APP_LOG.error((Object)"Error testing connection.", e3);
            Logs.APP_LOG.error((Object)"Connection failed.");
            test.setPass(false);
        }
        finally {
            Logs.APP_LOG.removeAppender((Appender)appender);
            NDC.pop();
            test.setLog(writer.toString());
        }
        return test;
    }

    @Override
    @AdminRPCMethod
    public List<String> getAllVobs() throws OperationFailureException {
        throw new OperationFailureException("ClearCase is no longer supported.");
    }

    @Override
    @AdminRPCMethod
    public List<String> getAllProjects() throws OperationFailureException {
        throw new OperationFailureException("ClearCase is no longer supported.");
    }

    @Override
    @AdminRPCMethod
    public List<String> getClearCaseBranches(String vob) throws OperationFailureException {
        throw new OperationFailureException("ClearCase is no longer supported.");
    }

    @Override
    @AdminRPCMethod
    public List<String> getClearCaseStreams(String project) throws OperationFailureException {
        throw new OperationFailureException("ClearCase is no longer supported.");
    }

    private String storeKeyInSession(KeyPair keypair) {
        String newKey = UUID.randomUUID().toString();
        HttpSession session = TotalityFilter.getRequest().getSession();
        session.setAttribute(newKey + ".public", (Object)keypair.getPublicKey());
        session.setAttribute(newKey + ".private", (Object)keypair.getPrivateKey());
        return newKey;
    }

    private Pair<String, String> loadKeyFromSession(String keyname) {
        HttpSession session = TotalityFilter.getRequest().getSession();
        return Pair.newInstance((String)session.getAttribute(keyname + ".public"), (String)session.getAttribute(keyname + ".private"));
    }

    @Override
    @AdminRPCMethod
    public GwtSshKey generateSSHKey(String name) throws OperationFailureException {
        try {
            Logs.APP_LOG.info((Object)("generating key pair for '" + name + "'"));
            KeyPair keypair = this.sshKeyManager.generateKeyPair(name);
            String newKey = this.storeKeyInSession(keypair);
            return new GwtSshKey(newKey, keypair.getPublicKey());
        }
        catch (Exception e2) {
            String message = "Failed to generate ssh key '" + name + "'. Check logs for more details.";
            Logs.APP_LOG.warn((Object)message, (Throwable)e2);
            throw new OperationFailureException(message);
        }
    }

    private void initAuthenticationOptions(AuthenticationOptions authOptions) throws IOException {
        if (StringUtils.isNotEmpty((String)authOptions.getKeyName()) && this.sshKeyManager.getPublicKey(authOptions.getKeyName()).exists()) {
            authOptions.setStyle(AuthenticationStyle.GEN_SSH_KEY_PAIR);
            authOptions.setPublicKey(this.sshKeyManager.getPublicKeyContents(authOptions.getKeyName()));
        }
    }

    private RepositoryDetails toRepoDetails(RepositoryData repo) throws IOException {
        switch (repo.getType()) {
            case CVS: {
                return new CvsRepositoryDetailsServerBuilder().toClientType((CvsRepositoryData)repo);
            }
            case SUBVERSION: {
                return new SvnRepositoryDetailsServerBuilder().toClientType((SvnRepositoryData)repo);
            }
            case CLEARCASE: {
                return new ObsoleteRepositoryDetailsServerBuilder().toClientType((ObsoleteRepositoryData)repo);
            }
            case PERFORCE: {
                return new PerforceRepositoryDetailsServerBuilder().toClientType((P4RepositoryData)repo);
            }
            case HG: {
                MercurialRepositoryDetails hgDetails = new MercurialRepositoryDetailsServerBuilder().toClientType((HgRepositoryData)repo);
                this.initAuthenticationOptions(hgDetails.getAuthenticationOptions());
                return hgDetails;
            }
            case GIT: {
                GitRepositoryDetails gitDetails = new GitRepositoryDetailsServerBuilder().toClientType((GitRepositoryData)repo);
                this.initAuthenticationOptions(gitDetails.getAuthenticationOptions());
                return gitDetails;
            }
        }
        throw new IllegalArgumentException("Unsupported repository " + repo.getType().name());
    }

    private PerRepositoryOptions toPerRepoOptions(RepositoryData repo) throws DbException {
        com.atlassian.fisheye.spi.admin.data.RepositoryOptions repoOptions = this.repoAdminService.getRepositoryOptions(repo.getName());
        return new PerRepositoryOptions(new LinkersSettings(RepositoryOptionsServerBuilder.toSimpleLinkersClientType(repoOptions.getSimpleLinkers()), RepositoryOptionsServerBuilder.toAdvancedLinkersClientType(repoOptions.getAdvancedLinkers())), repoOptions.isUsingDefaultsPermissions(), repoOptions.isAllowAnon(), repoOptions.isAllowLoggedUsers(), RepositoryOptionsServerBuilder.toGroupsSecuritiesClientType(repoOptions.getRequiredGroups()), new AllowProcessSettings(RepositoryOptionsServerBuilder.toCaseAwarePaths(repoOptions.getAllowIncludes()), RepositoryOptionsServerBuilder.toCaseAwareGlobs(repoOptions.getAllowExcludes())), RepositoryOptionsServerBuilder.toHiddenDirsClientType(repoOptions.getHiddenDirectories()), RepositoryOptionsServerBuilder.toTarballSettingsClientType(repoOptions.getTarballSettings()), RepositoryOptionsServerBuilder.toUpdateOptionsClientType(repoOptions.getUpdateOptions()), RepositoryOptionsServerBuilder.toCommitMessageSyntaxSettingsClientType(repoOptions.getCommitMessageSyntaxSettings()), repoOptions.isChangesetDiscussionsEnabled(), repoOptions.isWatchesEnabled(), this.getAuthAvailable(), ExternalAuthSettingsServerHelper.toExternalAuthSettingsClientType(repoOptions.getExternalAuthSettings()), repoOptions.getMaxIndexableSize(), repoOptions.getShowCheckoutURL(), new CheckoutURLAttributes(repoOptions.getCheckoutURL()));
    }

    private void copy(SymbolicRule from, SvnSymbolicRuleType to) {
        to.setRegex(from.getRegex());
        to.setName(from.getName());
        to.setLogical(from.getLogical());
    }

    private String generateMsgAndLogRepoActionFailure(String name, String action, Exception e2) {
        String message = String.format("Failed to %s repository %s: %s", action, name, e2.getMessage());
        Logs.APP_LOG.error((Object)message, (Throwable)e2);
        return message;
    }

    private void ensureRepoExists(String name) throws NoSuchRepositoryException {
        if (this.repositoryManager.getRepository(name) == null) {
            throw new NoSuchRepositoryException("A repository with the name \"" + name + "\" does not exist.");
        }
    }

    private void ensureRepoInRightState(String name, RepositoryState state, String desiredAction, RepositoryState needed) throws InvalidRepositoryStateException {
        if (state != needed) {
            throw new InvalidRepositoryStateException(String.format("Repository '%s' (currently %s) must be %s before %s.", name, state.name().toLowerCase(Locale.US), needed.name().toLowerCase(Locale.US), desiredAction));
        }
    }

    private void ensureRepoIsStarted(String name, String desiredAction) throws InvalidRepositoryStateException {
        this.ensureRepoInRightState(name, this.repoAdminService.getState(name), desiredAction, RepositoryState.RUNNING);
    }

    private void ensureRepoIsA(String name, RepositoryKind kind) throws NoSuchRepositoryException {
        if (kind != this.toRepoKind(this.repoAdminService.getRepositoryData(name))) {
            throw new NoSuchRepositoryException(String.format("This operation is invalid because the repository %s is not of type %s", name, kind.getPrettyName()));
        }
    }

    private RepositoryKind toRepoKind(RepositoryData repo) {
        switch (repo.getType()) {
            case CVS: {
                return RepositoryKind.CVS;
            }
            case GIT: {
                return RepositoryKind.GIT;
            }
            case PERFORCE: {
                return RepositoryKind.PERFORCE;
            }
            case SUBVERSION: {
                return RepositoryKind.SUBVERSION;
            }
            case CLEARCASE: {
                return RepositoryKind.CLEARCASE;
            }
            case HG: {
                return RepositoryKind.MERCURIAL;
            }
        }
        throw new IllegalArgumentException("Unexpected repository type: " + repo.getType());
    }

    private String messageFor(RepositoryStatus status) {
        return status.isMessageAvailable() ? status.getMessage() : null;
    }

    private com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryState repoStateFor(RepositoryData repo, boolean enabled) {
        if (enabled) {
            RepositoryState state = this.repoAdminService.getState(repo.getName());
            if (state != null) {
                return com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryState.valueOf(state.name());
            }
            throw new RuntimeException("State of an enabled repository cannot be null");
        }
        return com.atlassian.fecru.gwt.admin.shared.repositories.RepositoryState.DISABLED;
    }

    private List<ScmPluginRepositorySummary> listRepos(SCMModule scmModule) {
        LinkedList<ScmPluginRepositorySummary> repoNames = new LinkedList<ScmPluginRepositorySummary>();
        for (SCMRepository repository : scmModule.getRepositories()) {
            repoNames.add(new ScmPluginRepositorySummary(repository.getName(), repository.getDescription()));
        }
        return repoNames;
    }

    private String lastIndexUpdate(RepositoryIndexingStatus status) {
        Date lastScanTime;
        if (status != null && (lastScanTime = status.getLastScanTime()) != null) {
            return DateHelper.age(lastScanTime.getTime(), System.currentTimeMillis()) + " ago";
        }
        return null;
    }

    private RepositoryIndexingDetails indexingDetailsFor(RepositoryIndexingStatus indexingStatus) {
        if (indexingStatus == null) {
            return new RepositoryIndexingDetails(false, false, false, "");
        }
        return new RepositoryIndexingDetails(indexingStatus.isFullIndexingInProgress(), indexingStatus.isIncrementalIndexingInProgress(), indexingStatus.isLinesOfContentIndexingInProgress(), indexingStatus.getMessage());
    }

    private void ensureRepoEnabledState(String name, boolean shouldAlreadyBeEnabled) throws InvalidRepositoryStateException {
        if (shouldAlreadyBeEnabled ^ this.repoAdminService.isEnabled(name)) {
            throw new InvalidRepositoryStateException(String.format("Operation not permitted. Repository: '%s' is not " + (shouldAlreadyBeEnabled ? "enabled" : "disabled") + ".", name));
        }
    }

    protected List<WebItem> webItemsFor(String name) {
        return this.convert(WebFragmentDataFactory.getWebItemsForRepo(this.adminRequestTracker.getCurrentRequestDetails().getServletRequest(), "system.admin.repo.operation", name));
    }

    private List<WebItem> convert(List<WebItemData> in) {
        ArrayList<WebItem> out = new ArrayList<WebItem>(in.size());
        for (WebItemData inWebItem : in) {
            out.add(new WebItem(inWebItem.getUrl(), inWebItem.getLinkText(), inWebItem.getTooltip(), inWebItem.getIconUrl(), inWebItem.getHasIcon(), inWebItem.getHasTooltip(), inWebItem.getIconWidth(), inWebItem.getIconHeight(), inWebItem.getStyleClass(), inWebItem.getModuleKey(), inWebItem.getParams()));
        }
        return out;
    }

    @Override
    public AdminRequestTracker getAdminTracker() {
        return this.adminRequestTracker;
    }

    private static interface ConnectionTester {
        public void test() throws Exception;
    }

    private static abstract class RepoAction {
        private RepoAction() {
        }

        public RepositoryUpdateResult update() throws RepositoryConfigException {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private static abstract class ErrorHandlingContextFunction
    implements WebFragmentDataFactory.ContextFunction<WebPanelModuleDescriptor, RepositoryAdminTabData> {
        private ErrorHandlingContextFunction() {
        }

        @Override
        public RepositoryAdminTabData error(WebPanelModuleDescriptor item, Exception e2) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e2.printStackTrace(pw);
            pw.close();
            return new RepositoryAdminTabData(item.getKey(), "Error displaying plugin item", sw.toString());
        }
    }
}

