/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server;

import com.atlassian.fecru.gwt.admin.client.GlobalSettingsAdminRpcService;
import com.atlassian.fecru.gwt.admin.server.AdminRPCMethod;
import com.atlassian.fecru.gwt.admin.server.AdminRequestTracker;
import com.atlassian.fecru.gwt.admin.server.AdminService;
import com.atlassian.fecru.gwt.admin.shared.AuthorizationException;
import com.atlassian.fecru.gwt.admin.shared.OperationFailureException;
import com.atlassian.fecru.gwt.admin.shared.globalsettings.AdminUser;
import com.atlassian.fecru.gwt.admin.shared.globalsettings.avatar.AvatarUsage;
import com.atlassian.fecru.gwt.admin.shared.globalsettings.frontpage.FrontPageMessages;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.AvatarManager;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ContentType;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="GlobalSettingsAdminRpcService")
public class GlobalSettingsAdminRpcServiceImpl
implements GlobalSettingsAdminRpcService,
AdminService {
    private final AdminRequestTracker adminRequestTracker;
    private final AvatarManager avatarManager;
    private final EffectiveUserProvider effectiveUserProvider;

    @Autowired
    public GlobalSettingsAdminRpcServiceImpl(AdminRequestTracker adminRequestTracker, AvatarManager avatarManager, EffectiveUserProvider effectiveUserProvider) {
        this.adminRequestTracker = adminRequestTracker;
        this.avatarManager = avatarManager;
        this.effectiveUserProvider = effectiveUserProvider;
    }

    @Override
    @AdminRPCMethod
    public FrontPageMessages getFrontPageMessages() throws AuthorizationException {
        ContentType content = AppConfig.getsConfig().getConfig().getContent();
        return new FrontPageMessages(content == null ? "" : content.getFrontPageMessage(), content == null ? "" : content.getSupportMessage());
    }

    @Override
    @AdminRPCMethod
    public void setMessages(String welcomeMessage, String supportMessage) throws AuthorizationException, OperationFailureException {
        ContentType content = AppConfig.getsConfig().getConfig().getContent();
        if (content == null) {
            content = ContentType.Factory.newInstance();
        }
        try {
            content.setFrontPageMessage(welcomeMessage);
            content.setSupportMessage(supportMessage);
            AppConfig.getsConfig().getConfig().setContent(content);
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            throw new OperationFailureException(e2);
        }
    }

    @Override
    @AdminRPCMethod
    public AvatarUsage getAvatarUsage() throws AuthorizationException {
        AvatarUsage.Kind kind;
        AvatarTypeInfo avatar = this.avatarManager.getAvatarTypeInformation();
        return new AvatarUsage(kind, (kind = this.avatarUsageKindFor(avatar)) == AvatarUsage.Kind.EXTERNAL ? avatar.getUrl() : null, kind == AvatarUsage.Kind.EXTERNAL ? avatar.getSuffix() : null);
    }

    @Override
    @AdminRPCMethod
    public void setAvatarUsage(AvatarUsage avatarUsage) throws AuthorizationException, OperationFailureException {
        try {
            AvatarTypeInfo avatar = this.avatarManager.getAvatarTypeInformation();
            avatar.setType(avatarUsage.getKind().name().toLowerCase(), avatarUsage.getExternalUrl(), avatarUsage.getExternalSuffix());
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            throw new OperationFailureException(e2);
        }
    }

    @Override
    @AdminRPCMethod
    public AdminUser getAdminUser() throws AuthorizationException {
        FecruUser user = this.effectiveUserProvider.getEffectiveUser();
        return user == null ? null : new AdminUser(user.getDisplayName(), user.getEmail());
    }

    private AvatarUsage.Kind avatarUsageKindFor(AvatarTypeInfo avatar) {
        if (avatar.isExternal()) {
            return AvatarUsage.Kind.EXTERNAL;
        }
        return AvatarUsage.Kind.INTERNAL;
    }

    @Override
    public AdminRequestTracker getAdminTracker() {
        return this.adminRequestTracker;
    }
}

