/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server;

import com.atlassian.fecru.gwt.admin.server.AdminService;
import com.atlassian.fecru.gwt.admin.shared.AuthorizationException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AdminSecurityAspect {
    @Pointcut(value="@within(org.springframework.stereotype.Component)")
    private void classIsSpringComponent() {
    }

    @Pointcut(value="execution(@com.atlassian.fecru.gwt.admin.server.AdminRPCMethod public * *(..))")
    private void anyPublicAdminMethod() {
    }

    @Pointcut(value="within(com.atlassian.fecru.gwt.admin.server.*)")
    private void classIsGWTAdminService() {
    }

    @Around(value="classIsSpringComponent() && classIsGWTAdminService() && anyPublicAdminMethod()")
    public Object doCloseSession(ProceedingJoinPoint method) throws Throwable {
        if (!((AdminService)method.getThis()).getAdminTracker().getCurrentRequestDetails().isAdminUser()) {
            throw new AuthorizationException();
        }
        return method.proceed();
    }
}

