/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.gwt.admin.server;

import com.atlassian.fecru.gwt.servlet.GwtRPCRequestTracker;
import com.atlassian.fecru.gwt.servlet.GwtRPCRoutingServlet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.admin.interceptors.LoginInterceptor;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="GWTAdminRequestTracker")
public class AdminRequestTracker
implements GwtRPCRequestTracker {
    private static final ThreadLocal<RequestDetails> REQUESTDETAILS = new ThreadLocal();
    private final UserManager userManager;

    @Autowired
    public AdminRequestTracker(UserManager userManager) {
        this.userManager = userManager;
    }

    public RequestDetails getCurrentRequestDetails() {
        return REQUESTDETAILS.get();
    }

    @Override
    public final void onRequestStarted(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        boolean adminUser = false;
        try {
            adminUser = this.isAdminUser(servletRequest);
        }
        catch (DbException e2) {
            Logger.getLogger(GwtRPCRoutingServlet.class).error((Object)"Failed to check if admin user");
        }
        REQUESTDETAILS.set(new RequestDetails(this.userManager.validateCurrentUser(servletRequest, servletResponse), adminUser, servletRequest.getLocale(), servletRequest, servletResponse));
    }

    @Override
    public final void onRequestEnded(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        REQUESTDETAILS.remove();
    }

    protected boolean isAdminUser(HttpServletRequest servletRequest) throws DbException {
        return LoginInterceptor.isAdminUser(servletRequest);
    }

    public static class RequestDetails {
        private final UserLogin login;
        private final boolean adminUser;
        private final Locale locale;
        private final HttpServletRequest servletRequest;
        private final HttpServletResponse servletResponse;

        public RequestDetails(UserLogin login, boolean adminUser, Locale locale, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
            this.login = login;
            this.adminUser = adminUser;
            this.locale = locale;
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }

        public UserLogin getLogin() {
            return this.login;
        }

        public boolean isAdminUser() {
            return this.adminUser;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public HttpServletRequest getServletRequest() {
            return this.servletRequest;
        }

        public HttpServletResponse getServletResponse() {
            return this.servletResponse;
        }
    }
}

