/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.checkouturl.impl;

import com.atlassian.fecru.checkouturl.CheckoutUrlManager;
import com.atlassian.fecru.checkouturl.impl.DefaultCheckoutUrlAdminManager;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultCheckoutUrlManager
implements CheckoutUrlManager {
    private final DefaultCheckoutUrlAdminManager cloneUrlAdminManager;

    @Autowired
    public DefaultCheckoutUrlManager(DefaultCheckoutUrlAdminManager cloneUrlAdminManager) {
        this.cloneUrlAdminManager = cloneUrlAdminManager;
    }

    @Override
    public CheckoutUrlManager.CloneCommand getCloneCommand(String repoName, String path) {
        Boolean show = this.cloneUrlAdminManager.getRepositoryShowCheckoutUrl(repoName);
        if (show == null) {
            show = this.cloneUrlAdminManager.getDefaultShowCheckoutUrl();
        }
        return show != false ? this.createCloneCommand(repoName, path) : null;
    }

    private CheckoutUrlManager.CloneCommand createCloneCommand(String repoName, String path) {
        Map<String, String> commandAttributes = this.cloneUrlAdminManager.getCheckoutUrl(repoName);
        if (commandAttributes == null) {
            commandAttributes = this.cloneUrlAdminManager.getDefaultCheckoutUrl(repoName, path);
        }
        return this.hasValues(commandAttributes) ? new CheckoutUrlManager.CloneCommand(commandAttributes, this.cloneUrlAdminManager.getCheckoutVerb(repoName), this.cloneUrlAdminManager.getCheckoutCommand(repoName), this.cloneUrlAdminManager.isSourceTreeAvailable(repoName)) : null;
    }

    private boolean hasValues(Map<String, String> commandAttributes) {
        for (String s2 : commandAttributes.values()) {
            if (StringUtils.isBlank((String)s2)) continue;
            return true;
        }
        return false;
    }
}

