/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.checkouturl.impl;

import com.atlassian.fecru.checkouturl.CheckoutURLAdminManager;
import com.atlassian.fecru.checkouturl.impl.CheckoutUrl;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.PropertiesType;
import com.cenqua.fisheye.config1.PropertyType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultCheckoutUrlAdminManager
implements CheckoutURLAdminManager {
    private final RootConfig rootConfig;
    private final RepositoryManager repositoryManager;

    @Autowired
    public DefaultCheckoutUrlAdminManager(RootConfig rootConfig, RepositoryManager repositoryManager) {
        this.rootConfig = rootConfig;
        this.repositoryManager = repositoryManager;
    }

    @Override
    public boolean getDefaultShowCheckoutUrl() {
        return this.rootConfig.getConfig().getRepositoryDefaults().getShowCheckoutUrl();
    }

    @Override
    public void setDefaultShowCheckoutUrl(boolean show) {
        this.rootConfig.getConfig().getRepositoryDefaults().setShowCheckoutUrl(show);
        this.saveConfig();
    }

    @Override
    public Boolean getRepositoryShowCheckoutUrl(String repoName) {
        RepositoryConfig config = this.getRepositoryConfig(repoName);
        return config.getRepositoryTypeConfig().isSetShowCheckoutUrl() ? Boolean.valueOf(config.getRepositoryTypeConfig().getShowCheckoutUrl()) : null;
    }

    @Override
    public void setRepositoryShowCheckoutUrl(String repoName, Boolean show) {
        RepositoryType config = this.getRepositoryConfig(repoName).getRepositoryTypeConfig();
        if (show == null) {
            if (config.isSetShowCheckoutUrl()) {
                config.unsetShowCheckoutUrl();
            }
        } else {
            config.setShowCheckoutUrl(show);
        }
        this.saveConfig();
    }

    @Override
    public Map<String, String> getDefaultCheckoutUrl(String repoName, String path) {
        RepositoryConfig config = this.getRepositoryConfig(repoName);
        CheckoutUrl type = this.typeForRepo(config);
        return type.checkoutUrlFromVCS(config, path);
    }

    @Override
    public Map<String, String> getDefaultCheckoutUrl(RepositoryData data) {
        CheckoutUrl type = this.typeForData(data);
        return type.checkoutUrlFromRepositoryData(data);
    }

    @Override
    public Map<String, String> getCheckoutUrl(String repoName) {
        RepositoryType config = this.getRepositoryConfig(repoName).getRepositoryTypeConfig();
        return config.isSetCheckoutAttributes() ? this.propertiesToMap(this.typeForRepo(this.getRepositoryConfig(repoName)), config.getCheckoutAttributes()) : null;
    }

    private Map<String, String> propertiesToMap(CheckoutUrl checkoutUrl, PropertiesType checkoutAttributes) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        for (String s2 : checkoutUrl.getFields()) {
            attrs.put(s2, this.findPropertyValue(checkoutAttributes, s2));
        }
        return attrs;
    }

    private String findPropertyValue(PropertiesType properties, String name) {
        for (PropertyType p2 : properties.getPropertyArray()) {
            if (!p2.getName().equals(name)) continue;
            return p2.getValue();
        }
        return "";
    }

    @Override
    public void setCheckoutUrl(String repoName, Map<String, String> attrs) {
        RepositoryType config = this.getRepositoryConfig(repoName).getRepositoryTypeConfig();
        if (config.isSetCheckoutAttributes()) {
            config.unsetCheckoutAttributes();
        }
        if (attrs != null) {
            PropertiesType pt = config.addNewCheckoutAttributes();
            this.mapToPropertiesType(attrs, pt);
        }
        this.saveConfig();
    }

    @Override
    public String getCheckoutVerb(String repoName) {
        RepositoryConfig config = this.getRepositoryConfig(repoName);
        CheckoutUrl type = this.typeForRepo(config);
        return type.getCheckoutVerb();
    }

    @Override
    public String getCheckoutCommand(String repoName) {
        RepositoryConfig config = this.getRepositoryConfig(repoName);
        CheckoutUrl type = this.typeForRepo(config);
        return type.getCheckoutCommand();
    }

    @Override
    public boolean isSourceTreeAvailable(String repoName) {
        RepositoryConfig config = this.getRepositoryConfig(repoName);
        CheckoutUrl type = this.typeForRepo(config);
        return type.getSourceTreeAvailable();
    }

    private void mapToPropertiesType(Map<String, String> attrs, PropertiesType propertiesType) {
        for (Map.Entry<String, String> e2 : attrs.entrySet()) {
            PropertyType pt = propertiesType.addNewProperty();
            pt.setName(e2.getKey());
            pt.setValue(e2.getValue());
        }
    }

    private CheckoutUrl typeForRepo(RepositoryConfig config) {
        switch (config.getRepositoryType()) {
            case CVS: {
                return CheckoutUrl.CVS;
            }
            case SVN: {
                return CheckoutUrl.SVN;
            }
            case P4: {
                return CheckoutUrl.P4;
            }
            case GIT: {
                return CheckoutUrl.GIT;
            }
            case CLEARCASE: {
                return CheckoutUrl.CLEARCASE;
            }
            case HG: {
                return CheckoutUrl.HG;
            }
        }
        throw new IllegalArgumentException("Unknown repository type '" + config.getRepositoryType().getFullName() + "'");
    }

    private CheckoutUrl typeForData(RepositoryData data) {
        switch (data.getType()) {
            case CVS: {
                return CheckoutUrl.CVS;
            }
            case SUBVERSION: {
                return CheckoutUrl.SVN;
            }
            case PERFORCE: {
                return CheckoutUrl.P4;
            }
            case GIT: {
                return CheckoutUrl.GIT;
            }
            case CLEARCASE: {
                return CheckoutUrl.CLEARCASE;
            }
            case HG: {
                return CheckoutUrl.HG;
            }
        }
        throw new IllegalArgumentException("Unknown repository type '" + data.getType().name() + "'");
    }

    private RepositoryConfig getRepositoryConfig(String repName) {
        RepositoryHandle h2 = this.repositoryManager.getRepository(repName);
        if (h2 == null) {
            throw new IllegalArgumentException("No repository named '" + repName + "' exists.");
        }
        return h2.getCfg();
    }

    private void saveConfig() {
        try {
            this.rootConfig.saveConfig();
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Failed to save configuration", (Throwable)e2);
        }
    }
}

