/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.checkouturl.impl;

import com.atlassian.fisheye.git.GitScmConfig;
import com.atlassian.fisheye.hg.HgScmConfig;
import com.atlassian.fisheye.spi.admin.data.GitRepositoryData;
import com.atlassian.fisheye.spi.admin.data.HgRepositoryData;
import com.atlassian.fisheye.spi.admin.data.P4RepositoryData;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.data.SvnRepositoryData;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.perforce.P4ScmConfig;
import com.cenqua.fisheye.perforce.P4Utils;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.util.SvnRepositoryPathUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

enum CheckoutUrl {
    CVS("checkout", "", (Boolean)false, new String[]{"URL"}){

        @Override
        public Map<String, String> checkoutUrlFromVCS(RepositoryConfig config, String path) {
            return CheckoutUrl.urlMap(null);
        }

        @Override
        public Map<String, String> checkoutUrlFromRepositoryData(RepositoryData config) {
            return CheckoutUrl.urlMap(null);
        }
    }
    ,
    SVN("checkout", "svn checkout ", (Boolean)false, new String[]{"URL"}){
        private final SvnRepositoryPathUtil svnRepositoryPathUtil = new SvnRepositoryPathUtil();

        @Override
        public Map<String, String> checkoutUrlFromVCS(RepositoryConfig config, String path) {
            Path p2;
            SvnScmConfig scmConfig = (SvnScmConfig)config.getScmConfig();
            Path path2 = p2 = StringUtils.isNotBlank((String)path) ? new Path(path) : Path.ROOT;
            if (StringUtils.isNotBlank((String)path)) {
                Path rootPath = scmConfig.getPathMatcher().getPhysicalRoot(p2);
                p2 = rootPath == null ? p2 : rootPath;
            }
            String url = this.svnRepositoryPathUtil.getPathURL(scmConfig.getRepoUrl(), new Path(scmConfig.getRepoPath()), p2);
            return CheckoutUrl.urlMap(this.suppressUnusableUrls(url));
        }

        @Override
        public Map<String, String> checkoutUrlFromRepositoryData(RepositoryData data) {
            SvnRepositoryData svnData = (SvnRepositoryData)data;
            return CheckoutUrl.urlMap(this.suppressUnusableUrls(this.svnRepositoryPathUtil.getPathURL(svnData.getUrl(), new Path(svnData.getPath()), Path.ROOT)));
        }
    }
    ,
    P4("view", "", (Boolean)false, new String[]{"Host", "Port", "Path"}){

        @Override
        public Map<String, String> checkoutUrlFromVCS(RepositoryConfig config, String path) {
            P4ScmConfig scmConfig = (P4ScmConfig)config.getScmConfig();
            String host = scmConfig.getServer();
            int port = scmConfig.getPort();
            String configPath = scmConfig.getPath();
            return this.checkoutAttributesFromHostPortPath(host, port, configPath);
        }

        private Map<String, String> checkoutAttributesFromHostPortPath(String host, Integer port, String path) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(3);
            attrs.put("Host", host);
            attrs.put("Port", port == null ? "1666" : Integer.toString(port));
            attrs.put("Path", P4Utils.getServerPath(path, Path.ROOT));
            return attrs;
        }

        @Override
        public Map<String, String> checkoutUrlFromRepositoryData(RepositoryData data) {
            P4RepositoryData p4Data = (P4RepositoryData)data;
            return this.checkoutAttributesFromHostPortPath(p4Data.getServer(), p4Data.getPort(), p4Data.getPath());
        }
    }
    ,
    GIT("clone", "git clone ", (Boolean)true, new String[]{"URL"}){

        @Override
        public Map<String, String> checkoutUrlFromVCS(RepositoryConfig config, String path) {
            GitScmConfig scmConfig = (GitScmConfig)config.getScmConfig();
            return CheckoutUrl.urlMap(this.suppressUnusableUrls(scmConfig.getLocation()));
        }

        @Override
        public Map<String, String> checkoutUrlFromRepositoryData(RepositoryData data) {
            return CheckoutUrl.urlMap(this.suppressUnusableUrls(((GitRepositoryData)data).getLocation()));
        }
    }
    ,
    HG("clone", "hg clone ", (Boolean)true, new String[]{"URL"}){

        @Override
        public Map<String, String> checkoutUrlFromVCS(RepositoryConfig config, String path) {
            HgScmConfig scmConfig = (HgScmConfig)config.getScmConfig();
            return CheckoutUrl.urlMap(this.suppressUnusableUrls(scmConfig.getLocation()));
        }

        @Override
        public Map<String, String> checkoutUrlFromRepositoryData(RepositoryData data) {
            return CheckoutUrl.urlMap(this.suppressUnusableUrls(((HgRepositoryData)data).getLocation()));
        }
    }
    ,
    CLEARCASE("", null, (Boolean)false, new String[0]){

        @Override
        public Map<String, String> checkoutUrlFromVCS(RepositoryConfig config, String path) {
            return null;
        }

        @Override
        public Map<String, String> checkoutUrlFromRepositoryData(RepositoryData data) {
            return null;
        }
    };

    private String verb;
    private final String[] fields;
    private String checkoutCommand;
    private Boolean isSourceTreeAvailable;

    private static Map<String, String> urlMap(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("URL", url);
        return map;
    }

    private CheckoutUrl(String verb, String checkoutCommand, Boolean isSourceTreeAvailable, String ... fields) {
        this.verb = verb;
        this.fields = fields;
        this.isSourceTreeAvailable = isSourceTreeAvailable;
        this.checkoutCommand = checkoutCommand;
    }

    String[] getFields() {
        return this.fields;
    }

    public abstract Map<String, String> checkoutUrlFromVCS(RepositoryConfig var1, String var2);

    public abstract Map<String, String> checkoutUrlFromRepositoryData(RepositoryData var1);

    public String getCheckoutVerb() {
        return this.verb;
    }

    protected String suppressUnusableUrls(String urlString) {
        URI uri = null;
        try {
            uri = new URI(urlString);
            return uri.getScheme() != null && uri.getHost() != null && !this.isFileProtocol(uri) && !this.isLocalhost(uri) && !this.isLoopback(uri) ? urlString : null;
        }
        catch (Exception e2) {
            return urlString;
        }
    }

    private boolean isLoopback(URI uri) {
        return uri.getHost().equals("127.0.0.1");
    }

    private boolean isLocalhost(URI uri) {
        return uri.getHost().toLowerCase().equals("localhost");
    }

    private boolean isFileProtocol(URI uri) {
        return uri.getScheme().equals("file");
    }

    public String getCheckoutCommand() {
        return this.checkoutCommand;
    }

    public boolean getSourceTreeAvailable() {
        return this.isSourceTreeAvailable;
    }

    protected static class Constants {
        public static final String URL = "URL";
        public static final String CLONE = "clone";
        public static final String CHECKOUT = "checkout";
        public static final String GIT_CLONE = "git clone ";
        public static final String HG_CLONE = "hg clone ";
        public static final String SVN_CHECKOUT = "svn checkout ";
        public static final String VIEW = "view";
        public static final String PORT = "Port";
        public static final String HOST = "Host";
        public static final String PATH = "Path";

        protected Constants() {
        }
    }
}

