/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.applinks;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.fecru.applinks.CredentialsRequiredMessage;
import com.atlassian.fecru.applinks.RemoteErrorMessage;
import com.cenqua.fisheye.web.filters.TotalityFilter;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RemoteRequestUIHelper {
    public static final String CREDENTIALS_REQUIRED = "credentialsRequired";
    public static final String REMOTE_ERRORS = "remoteErrors";

    public static void requestCredentials(CredentialsRequiredMessage credentialsRequiredMessage) {
        HttpServletRequest request = RemoteRequestUIHelper.getCurrentRequest();
        if (request == null) {
            return;
        }
        RemoteRequestUIHelper.getMessageSet(request, CREDENTIALS_REQUIRED).add(credentialsRequiredMessage);
    }

    public static void notifyRemoteError(ApplicationLink link, String message) {
        HttpServletRequest request = RemoteRequestUIHelper.getCurrentRequest();
        if (request == null) {
            return;
        }
        RemoteRequestUIHelper.getMessageSet(request, REMOTE_ERRORS).add(new RemoteErrorMessage(link, message));
    }

    private static <T> Set<T> getMessageSet(HttpServletRequest request, String key) {
        HashSet messages = (HashSet)request.getAttribute(key);
        if (messages == null) {
            messages = new HashSet();
            request.setAttribute(key, messages);
        }
        return messages;
    }

    private static HttpServletRequest getCurrentRequest() {
        return TotalityFilter.isInRequest() ? TotalityFilter.getRequest() : null;
    }
}

