/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleProjectEntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeRepositoryEntityType;
import com.atlassian.applinks.host.spi.AbstractInternalHostApplication;
import com.atlassian.applinks.host.spi.DefaultEntityReference;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.host.util.InstanceNameGenerator;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.crucible.spi.data.ProjectData;
import com.atlassian.crucible.spi.data.RepositoryData;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.spi.data.RepositoryDataFE;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.ActionDispatcherServlet;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="feCruHostApplication")
@AvailableToPlugins
public class FeCruHostApplication
extends AbstractInternalHostApplication
implements HostApplication,
InternalHostApplication {
    private final ApplicationId applicationId;
    private final String name;
    private final RootConfig rootConfig;
    private final ProjectManager projectManager;
    private final SecureProjectManager secureProjectManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private final TypeAccessor typeAccessor;
    private final UserManager userManager;
    private final RepositoryManager repositoryManager;
    private final PermissionManager permissionManager;
    private final URI documentationBaseUri = URI.create("http://confluence.atlassian.com/display/APPLINKS");
    private static final String CRU_ICON_PATH = "2static/images/cru_blue.png";
    private static final String FE_ICON_PATH = "2static/images/fe_blue-v2.png";

    @Autowired
    public FeCruHostApplication(RootConfig rootConfig, ProjectManager projectManager, EffectiveUserProvider effectiveUserProvider, TypeAccessor typeAccessor, PluginAccessor pluginAccessor, SecureProjectManager secureProjectManager, UserManager userManager, RepositoryManager repositoryManager, PermissionManager permissionManager) {
        super(pluginAccessor);
        this.rootConfig = rootConfig;
        this.projectManager = projectManager;
        this.effectiveUserProvider = effectiveUserProvider;
        this.typeAccessor = typeAccessor;
        this.secureProjectManager = secureProjectManager;
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
        this.permissionManager = permissionManager;
        try {
            this.name = new InstanceNameGenerator().generateInstanceName(rootConfig.getSiteURL());
        }
        catch (MalformedURLException e2) {
            Logs.APP_LOG.debug((Object)e2.getMessage(), (Throwable)e2);
            throw new RuntimeException("siteUrl returned from RootConfig is not a valid URL. " + e2.getMessage());
        }
        this.applicationId = this.getApplicationIdFromSid();
    }

    public URI getIconUrl() {
        return AppConfig.isCrucible() ? this.getStaticResourceUri(CRU_ICON_PATH) : this.getStaticResourceUri(FE_ICON_PATH);
    }

    public URI getDocumentationBaseUrl() {
        return this.documentationBaseUri;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationType getType() {
        return (ApplicationType)Preconditions.checkNotNull((Object)this.typeAccessor.getApplicationType(FishEyeCrucibleApplicationType.class), (Object)"FishEyeCrucibleApplicationType not installed!");
    }

    public Iterable<EntityReference> getLocalEntities() {
        final Principal principal = this.effectiveUserProvider.getEffectivePrincipal();
        return Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter(this.repositoryManager.getHandles(), (Predicate)new Predicate<RepositoryHandle>(){

            public boolean apply(RepositoryHandle handle) {
                return FeCruHostApplication.this.userManager.hasPermissionToAccess(principal, handle);
            }
        }), (Function)new Function<RepositoryHandle, EntityReference>(){

            public EntityReference apply(RepositoryHandle from) {
                return FeCruHostApplication.this.createFisheyeRepositoryEntityReference(from.getName());
            }
        }), (Iterable)Iterables.transform(this.secureProjectManager.getVisibleProjects(principal), (Function)new Function<Project, EntityReference>(){

            public EntityReference apply(Project from) {
                return FeCruHostApplication.this.createCrucibleProjectEntityReference(from.getProjKey(), from.getName());
            }
        }));
    }

    public boolean doesEntityExist(String key, Class<? extends EntityType> type) {
        return this.doesEntityExist(key, type, true);
    }

    public boolean doesEntityExistNoPermissionCheck(String key, Class<? extends EntityType> type) {
        return this.doesEntityExist(key, type, true);
    }

    private boolean doesEntityExist(String key, Class<? extends EntityType> type, boolean skipPermissionCheck) {
        String principalName;
        Principal effectivePrincipal = this.effectiveUserProvider.getEffectivePrincipal();
        String string = principalName = effectivePrincipal != null ? effectivePrincipal.getDisplayName() : null;
        if (FishEyeRepositoryEntityType.class.isAssignableFrom(type)) {
            boolean hasPemission;
            RepositoryHandle repository = this.repositoryManager.getRepository(key);
            if (repository == null) {
                Logs.APP_LOG.debug((Object)String.format("Repository %s was not found when trying to determine if entity exists of type: %s", key, type));
                return false;
            }
            boolean bl = hasPemission = skipPermissionCheck || this.userManager.hasPermissionToAccess(effectivePrincipal, repository);
            if (!hasPemission) {
                Logs.APP_LOG.debug((Object)String.format("Repository %s exists, however user %s does not have permission to access it.", repository, principalName));
            }
            return hasPemission;
        }
        if (FishEyeCrucibleProjectEntityType.class.isAssignableFrom(type)) {
            boolean hasPermission;
            Project project = this.projectManager.getProjectByKey(key);
            if (project == null) {
                Logs.APP_LOG.debug((Object)String.format("Project %s was not found when trying to determine if entity exists of type: %s", key, type));
                return false;
            }
            boolean bl = hasPermission = skipPermissionCheck || this.permissionManager.isProjectVisible(effectivePrincipal, project);
            if (!hasPermission) {
                Logs.APP_LOG.debug((Object)String.format("Project %s exists, however user %s does not have permission to access it.", project.getName(), principalName));
            }
            return hasPermission;
        }
        return false;
    }

    public EntityReference toEntityReference(Object o2) {
        EntityReference ref;
        if (o2 instanceof RepositoryHandle) {
            ref = this.createFisheyeRepositoryEntityReference(((RepositoryHandle)o2).getName());
        } else if (o2 instanceof RepositoryData) {
            ref = this.createFisheyeRepositoryEntityReference(((RepositoryData)o2).getName());
        } else if (o2 instanceof RepositoryDataFE) {
            ref = this.createFisheyeRepositoryEntityReference(((RepositoryDataFE)o2).getName());
        } else if (o2 instanceof com.atlassian.fisheye.spi.admin.data.RepositoryData) {
            ref = this.createFisheyeRepositoryEntityReference(((com.atlassian.fisheye.spi.admin.data.RepositoryData)o2).getName());
        } else if (o2 instanceof Project) {
            Project prj = (Project)o2;
            ref = this.createCrucibleProjectEntityReference(prj.getProjKey(), prj.getName());
        } else if (o2 instanceof ProjectData) {
            ProjectData prj = (ProjectData)o2;
            ref = this.createCrucibleProjectEntityReference(prj.getKey(), prj.getName());
        } else {
            throw new IllegalArgumentException("Unsupported argument type: " + o2.getClass().getName());
        }
        return ref;
    }

    public EntityReference toEntityReference(String key, Class<? extends EntityType> type) {
        Project project;
        EntityReference ref = null;
        if (FishEyeRepositoryEntityType.class.isAssignableFrom(type)) {
            if (this.doesEntityExistNoPermissionCheck(key, type)) {
                ref = this.createFisheyeRepositoryEntityReference(key);
            }
        } else if (FishEyeCrucibleProjectEntityType.class.isAssignableFrom(type) && (project = this.projectManager.getProjectByKey(key)) != null) {
            ref = this.createCrucibleProjectEntityReference(project.getProjKey(), project.getName());
        }
        return ref;
    }

    public boolean canManageEntityLinksFor(EntityReference entityReference) {
        return this.effectiveUserProvider.isAdmin();
    }

    public ApplicationId getId() {
        return this.applicationId;
    }

    public URI getBaseUrl() {
        try {
            return new URI(this.rootConfig.getSiteURL());
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException("RootConfig.getSiteURL() is not a valid URI!");
        }
    }

    public boolean hasPublicSignup() {
        return AppConfig.getsConfig().getConfig().getSecurity().getBuiltIn().getSignup().getEnabled();
    }

    private URI getStaticResourceUri(String pathFromStaticDir) {
        String urlString = this.rootConfig.getSiteURL() + "/" + ActionDispatcherServlet.STATIC_DIR + "/" + pathFromStaticDir;
        URI resourceUri = null;
        try {
            resourceUri = new URI(urlString);
        }
        catch (URISyntaxException e2) {
            Logs.APP_LOG.warn((Object)String.format("static resource URI (%s) is not a valid URI, returning null", urlString));
        }
        return resourceUri;
    }

    private EntityReference createCrucibleProjectEntityReference(String key, String name) {
        return new DefaultEntityReference(key, name, (EntityType)Preconditions.checkNotNull((Object)this.typeAccessor.getEntityType(FishEyeCrucibleProjectEntityType.class), (Object)(FishEyeCrucibleProjectEntityType.class.getSimpleName() + " not installed!")));
    }

    private EntityReference createFisheyeRepositoryEntityReference(String name) {
        return new DefaultEntityReference(name, name, (EntityType)Preconditions.checkNotNull((Object)this.typeAccessor.getEntityType(FishEyeRepositoryEntityType.class), (Object)(FishEyeRepositoryEntityType.class.getSimpleName() + " not installed!")));
    }

    private ApplicationId getApplicationIdFromSid() {
        String sid = (String)Preconditions.checkNotNull((Object)new FisheyeVersionInfo().getSid(), (Object)"sid");
        return new ApplicationId(UUID.nameUUIDFromBytes(sid.getBytes()).toString());
    }
}

