/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.analytics.collector;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.fecru.analytics.collector.UserManagementStatisticsService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="userManagementStatisticsService")
@AvailableToPlugins(value=UserManagementStatisticsService.class)
public class DefaultUserManagementStatisticsService
implements UserManagementStatisticsService {
    private static final Logger log = Logs.loggerFor(DefaultUserManagementStatisticsService.class);
    private final CrowdDirectoryService crowdDirectoryService;
    private final ApplicationManager applicationManager;
    private RootConfig rootConfig;

    @Autowired
    public DefaultUserManagementStatisticsService(CrowdDirectoryService crowdDirectoryService, ApplicationManager applicationManager, RootConfig rootConfig) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.applicationManager = applicationManager;
        this.rootConfig = rootConfig;
    }

    @Override
    @Transactional
    public Map<String, Integer> getDirectoryTypesStatistics() {
        HashMap stats = Maps.newHashMap();
        for (DirectoryType directoryType : DirectoryType.values()) {
            stats.put(directoryType.name().toLowerCase(), 0);
        }
        stats.put("total", 0);
        this.crowdDirectoryService.findAllDirectories().stream().filter(Directory::isActive).forEach(directory -> {
            DirectoryType type = directory.getType();
            stats.compute(type.name().toLowerCase(), (k2, v2) -> v2 + 1);
            stats.compute("total", (k2, v2) -> v2 + 1);
        });
        return stats;
    }

    @Override
    public boolean isInternalDirectoryEnabled() {
        return this.crowdDirectoryService.findAllDirectories().stream().filter(d2 -> d2.getType() == DirectoryType.INTERNAL).findFirst().map(Directory::isActive).orElse(false);
    }

    @Override
    public Optional<Boolean> getAjpAutoAdd() {
        boolean ajpEnabled = this.rootConfig.getConfig().getSecurity().isSetAjp();
        return ajpEnabled ? Optional.of(this.rootConfig.getConfig().getSecurity().getAjp().getAutoAdd()) : Optional.empty();
    }

    @Override
    public Optional<Boolean> getCustomAutoAdd() {
        boolean customEnabled = this.rootConfig.getConfig().getSecurity().isSetCustom();
        return customEnabled ? Optional.of(this.rootConfig.getConfig().getSecurity().getCustom().getAutoAdd()) : Optional.empty();
    }

    @Override
    @Transactional
    public Map<String, String> getCrowdApplicationAttributes() {
        try {
            Application application = this.applicationManager.findById(1L);
            return ImmutableMap.copyOf((Map)application.getAttributes());
        }
        catch (ApplicationNotFoundException e2) {
            log.warn((Object)"Could not find embedded crowd application", (Throwable)e2);
            return ImmutableMap.of();
        }
    }
}

