/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.analytics.collector;

import com.atlassian.fecru.analytics.collector.RepositoryPermissionStatisticsService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.RepositoryType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="repositoryPermissionStatisticsService")
@AvailableToPlugins
public class DefaultRepositoryPermissionStatisticsService
implements RepositoryPermissionStatisticsService {
    private final RootConfig rootConfig;

    @Autowired
    public DefaultRepositoryPermissionStatisticsService(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    @Override
    public Map<String, Integer> getRepositoryPermissionsStats() {
        int anonAccess = 0;
        int loggedInAccess = 0;
        int groupsRestrictions = 0;
        int customRestrictions = 0;
        for (RepositoryType repositoryType : this.rootConfig.getConfig().getRepositoryArray()) {
            if (!repositoryType.getEnabled()) continue;
            RepositoryConfig repositoryConfig = new RepositoryConfig(this.rootConfig, repositoryType, null, null, null);
            boolean anonAccessAllowed = repositoryConfig.isAnonAccessAllowed();
            boolean loggedInAccessAllowed = repositoryConfig.isLoggedInAccessAllowed();
            boolean groupsRestrictionSpecified = !repositoryConfig.getAllowedGroups().isEmpty();
            boolean customSpecified = repositoryConfig.isSetCustom();
            if (anonAccessAllowed) {
                ++anonAccess;
            }
            if (loggedInAccessAllowed) {
                ++loggedInAccess;
            }
            if (groupsRestrictionSpecified) {
                ++groupsRestrictions;
            }
            if (!customSpecified) continue;
            ++customRestrictions;
        }
        return ImmutableMap.of((Object)"anon", (Object)anonAccess, (Object)"loggedIn", (Object)loggedInAccess, (Object)"groups", (Object)groupsRestrictions, (Object)"custom", (Object)customRestrictions);
    }
}

