/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.analytics;

import com.atlassian.fisheye.util.DevMode;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.cenqua.fisheye.logging.Logs;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class DisableAnalyticsInDevTask {
    private final PluginSettingsFactory pluginSettingsFactory;

    @Autowired
    DisableAnalyticsInDevTask(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @PostConstruct
    private void disableAnalytics() {
        if (!this.isDevMode()) {
            return;
        }
        this.pluginSettingsFactory.createGlobalSettings().put("com.atlassian.analytics.client.configuration..analytics_enabled", (Object)Boolean.toString(false));
        Logs.APP_LOG.info((Object)"[dev] Disabled analytics collection");
    }

    private boolean isDevMode() {
        return DevMode.isDevMode() || DevMode.isAtlassianDevMode();
    }
}

