/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.activityitem.logitem;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.fecru.activityitem.ActivityItemData;
import com.atlassian.fecru.activityitem.ActivityItemDataService;
import com.atlassian.fecru.activityitem.ActivityItemSearchCriteria;
import com.atlassian.fecru.activityitem.logitem.LogItemConverter;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.page.PagedResourceIterable;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.WithSession;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.LogItemSearchCriteria;
import com.cenqua.crucible.model.managers.Order;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="activityItemDataService")
@AvailableToPlugins
public class LogItemActivityItemDataService
implements ActivityItemDataService {
    private static final List<ActivityItemDataService.Type> TYPES_FILTER_ALL = ImmutableList.copyOf((Object[])ActivityItemDataService.Type.values());
    private final ReviewService reviewService;
    private final ReviewManager reviewManager;
    private final LogItemManager logItemManager;
    @Resource(name="activityItemDataService")
    protected ActivityItemDataService self;
    private final Map<ActivityItemDataService.Type, LogItemConverter> itemLogItemConvertersByType;
    private final Map<String, LogItemConverter> itemLogItemConvertersByAction;

    @Autowired
    public LogItemActivityItemDataService(ReviewService reviewService, ReviewManager reviewManager, LogItemManager logItemManager, List<LogItemConverter> logItemConverters) {
        this.reviewService = reviewService;
        this.logItemManager = logItemManager;
        this.reviewManager = reviewManager;
        this.itemLogItemConvertersByType = logItemConverters.stream().collect(Collectors.toMap(LogItemConverter::type, Function.identity(), (logItemConverter1, logItemConverter2) -> {
            throw new IllegalStateException(String.format("%s - more the one LogItemConverter for type: %s is defined - %s, %s", new Object[]{LogItemActivityItemDataService.class.getName(), logItemConverter1.type(), logItemConverter1, logItemConverter2}));
        }));
        this.itemLogItemConvertersByAction = logItemConverters.stream().flatMap(logItemConverter -> logItemConverter.actions().stream().map(action -> Pair.pair((Object)action, (Object)logItemConverter))).collect(Collectors.toMap(Pair::left, Pair::right, (logItemConverter1, logItemConverter2) -> {
            throw new IllegalStateException(String.format("%s - more the one LogItemConverter for action(s): %s is defined - %s, %s", LogItemActivityItemDataService.class.getName(), Sets.intersection(logItemConverter1.actions(), logItemConverter2.actions()), logItemConverter1, logItemConverter2));
        }));
    }

    @Override
    @WithSession
    @Transactional(readOnly=true)
    public Page<ActivityItemData> list(ActivityItemSearchCriteria searchCriteria, PageRequest pageRequest) throws NotFoundException, NotPermittedException {
        Preconditions.checkNotNull((Object)searchCriteria);
        Preconditions.checkNotNull((Object)pageRequest);
        Preconditions.checkArgument((searchCriteria.getReviewPermId() != null ? 1 : 0) != 0, (Object)"searchCriteria.reviewPermId can't be null");
        if (!this.reviewService.hasPermission(new PermId(searchCriteria.getReviewPermId()), UserActionManager.ACTION_VIEW)) {
            throw new NotPermittedException(String.format("You do not have permission to %s the review %s", UserActionManager.ACTION_VIEW, searchCriteria.getReviewPermId()));
        }
        int reviewId = this.reviewManager.getReviewByPermaId(searchCriteria.getReviewPermId()).getId();
        List<ActivityItemDataService.Type> typeFilter = searchCriteria.getTypesFilter().isEmpty() ? TYPES_FILTER_ALL : searchCriteria.getTypesFilter();
        LogItemSearchCriteria logItemSearchCriteria = LogItemSearchCriteria.create().reviewIds(reviewId).actions(this.actionsFrom(typeFilter)).minDate(searchCriteria.getCreatedAfter()).order(Order.DESC).start(pageRequest.getStart()).limit(pageRequest.getLimit() + 1);
        List<LogItem> logItemsWithNoUsers = this.logItemManager.getLogItems(logItemSearchCriteria);
        List logItems = logItemsWithNoUsers.stream().filter(logItem -> logItem.getUserId() != null).collect(Collectors.toList());
        return Page.Builder.buildFromLimitPlusOneCollection(logItems, (PageRequest)pageRequest).transform(logItem -> (ActivityItemData)this.itemLogItemConvertersByAction.get(logItem.getAction()).apply(logItem));
    }

    @Override
    public PagedResourceIterable<ActivityItemData> listIterable(ActivityItemSearchCriteria searchCriteria) {
        return new PagedResourceIterable<ActivityItemData>(pageRequest -> this.self.list(searchCriteria, pageRequest));
    }

    private Set<String> actionsFrom(List<ActivityItemDataService.Type> types) {
        return types.stream().flatMap(type -> this.itemLogItemConvertersByType.get(type).actions().stream()).collect(Collectors.toSet());
    }
}

