/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.activityitem.logitem;

import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.DefaultSPIUserUtils;
import com.atlassian.fecru.activityitem.ActivityItemData;
import com.atlassian.fecru.activityitem.logitem.LogItemConverter;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.web.RequestContext;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.fisheye.user.UserManager;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLoginItemConverter
implements LogItemConverter {
    public static final String ACTIVITY_ITEM_LOG_ITEM_ID_PREFIX = "logItem";
    private UserManager userManager;
    private RequestContext requestContext;

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Autowired
    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public ActivityItemData apply(LogItem logItem) {
        return new ActivityItemData.ActivityItemDataBuilder(this.type()).created(logItem.getCreateDate()).id((Serializable)((Object)(ACTIVITY_ITEM_LOG_ITEM_ID_PREFIX + logItem.getId()))).user(this.getUserData(logItem.getUserId())).addData(this.getCustomDataFor(logItem)).build();
    }

    @Nullable
    private UserData getUserData(@Nullable Integer userId) {
        Optional<String> avatarUrlForCurrentRequest;
        if (userId == null) {
            return null;
        }
        FecruUser user = this.userManager.getUserById(userId);
        UserData userData = DefaultSPIUserUtils.USER_TO_USERDATA_FUNCTION.apply(user);
        if (userData != null && (avatarUrlForCurrentRequest = this.getAvatarUrlForCurrentRequestIfRequestAvailable(user)).isPresent()) {
            userData.setAvatarUrl(avatarUrlForCurrentRequest.get());
        }
        return userData;
    }

    private Optional<String> getAvatarUrlForCurrentRequestIfRequestAvailable(FecruUser user) {
        Optional<HttpServletRequest> httpServletRequest = this.requestContext.getRequest();
        if (httpServletRequest.isPresent()) {
            String avatarUrlAbs = AvatarTypeInfo.getAvatarUrlAbs(httpServletRequest.get(), user, (Integer)32, false, false);
            return Optional.ofNullable(avatarUrlAbs);
        }
        return Optional.empty();
    }

    @Nullable
    protected abstract Map<String, Serializable> getCustomDataFor(LogItem var1);
}

