/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.activityitem;

import com.atlassian.fecru.activityitem.ActivityItemDataService;
import com.google.common.collect.Lists;
import java.time.ZonedDateTime;
import java.util.List;
import javax.annotation.Nullable;

public class ActivityItemSearchCriteria {
    private final String reviewPermId;
    private List<ActivityItemDataService.Type> typesFilter = Lists.newArrayList();
    @Nullable
    private ZonedDateTime createdAfter;

    private ActivityItemSearchCriteria(String reviewPermId) {
        this.reviewPermId = reviewPermId;
    }

    public static ActivityItemSearchCriteria create(String reviewPermId) {
        return new ActivityItemSearchCriteria(reviewPermId);
    }

    public ActivityItemSearchCriteria type(ActivityItemDataService.Type type) {
        if (type != null) {
            this.typesFilter.add(type);
        }
        return this;
    }

    public ActivityItemSearchCriteria types(List<ActivityItemDataService.Type> types) {
        if (types != null && !types.isEmpty()) {
            this.typesFilter.addAll(types);
        }
        return this;
    }

    public ActivityItemSearchCriteria createdAfter(ZonedDateTime createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public String getReviewPermId() {
        return this.reviewPermId;
    }

    public List<ActivityItemDataService.Type> getTypesFilter() {
        return this.typesFilter;
    }

    @Nullable
    public ZonedDateTime getCreatedAfter() {
        return this.createdAfter;
    }
}

