/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.activityitem;

import com.atlassian.crucible.spi.data.ISO8601ZonedDateTimeAdapter;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.fecru.activityitem.ActivityItemDataService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ActivityItemData {
    public final ActivityItemDataService.Type type;
    public final Serializable id;
    @XmlJavaTypeAdapter(value=ISO8601ZonedDateTimeAdapter.class)
    public final ZonedDateTime created;
    @Nullable
    public final UserData user;
    @Nullable
    public final ImmutableMap<String, Serializable> data;

    private ActivityItemData(ActivityItemDataService.Type type, Serializable id, ZonedDateTime created, @Nullable UserData user, @Nullable Map<String, Serializable> data) {
        this.type = (ActivityItemDataService.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"ActiveItem.type cannot be null"));
        this.id = (Serializable)Preconditions.checkNotNull((Object)id, (Object)"ActiveItem.id cannot be null");
        this.created = (ZonedDateTime)Preconditions.checkNotNull((Object)created, (Object)"ActiveItem.created cannot be null");
        this.user = user;
        this.data = data != null ? ImmutableMap.copyOf(data) : null;
    }

    public static class ActivityItemDataBuilder {
        private ActivityItemDataService.Type type;
        private Serializable id;
        private ZonedDateTime created;
        private UserData user;
        private Map<String, Serializable> data;

        public ActivityItemDataBuilder(ActivityItemDataService.Type type) {
            this.type = type;
        }

        public ActivityItemDataBuilder id(Serializable id) {
            this.id = id;
            return this;
        }

        public ActivityItemDataBuilder created(ZonedDateTime created) {
            this.created = created;
            return this;
        }

        public ActivityItemDataBuilder created(Date created) {
            if (created != null) {
                Instant instant = Instant.ofEpochMilli(created.getTime());
                this.created = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
            } else {
                this.created = null;
            }
            return this;
        }

        public ActivityItemDataBuilder user(UserData userData) {
            this.user = userData;
            return this;
        }

        public ActivityItemDataBuilder addData(@Nullable Map<String, Serializable> keyValues) {
            if (keyValues != null) {
                if (this.data == null) {
                    this.data = Maps.newLinkedHashMap();
                }
                this.data.putAll(keyValues);
            }
            return this;
        }

        public ActivityItemDataBuilder addData(String key, Serializable value) {
            if (this.data == null) {
                this.data = Maps.newLinkedHashMap();
            }
            this.data.put(key, value);
            return this;
        }

        public ActivityItemData build() {
            return new ActivityItemData(this.type, this.id, this.created, this.user, this.data);
        }
    }
}

