/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.actions;

import com.atlassian.extras.api.ProductLicense;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.web.admin.interceptors.LoginInterceptor;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.xwork.ActionSupport;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public final class LicenseExceededAction
extends ActionSupport
implements ServletRequestAware {
    @Autowired
    private RootConfig rootConfig;
    @Autowired
    private LicenseManager licenseManager;
    private LicenseInfo license = null;
    private ProductLicense fisheyeLicense = null;
    private ProductLicense crucibleLicense = null;
    private int countFEUser;
    private int countCRUUser;
    private boolean admin;
    private HttpServletRequest request;

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        this.license = this.rootConfig.getLicense();
        if (this.license == null) {
            throw new IllegalStateException("No license is specified");
        }
        this.fisheyeLicense = this.license.getFisheyeLicense();
        this.crucibleLicense = this.license.getCrucibleLicense();
        this.countFEUser = this.licenseManager.getFishEyeUsersCount();
        this.countCRUUser = this.licenseManager.getCrucibleUsersCount();
        this.admin = LoginInterceptor.isAdminUser(this.request);
        return "success";
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public LicenseInfo getLicense() {
        return this.license;
    }

    public ProductLicense getFisheyeLicense() {
        return this.fisheyeLicense;
    }

    public ProductLicense getCrucibleLicense() {
        return this.crucibleLicense;
    }

    public int getCountFEUser() {
        return this.countFEUser;
    }

    public int getCountCRUUser() {
        return this.countCRUUser;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public Object getExcessFEUsers() {
        return this.licenseManager.getExcessFEUsers();
    }

    public Object getExcessCruUsers() {
        return this.licenseManager.getExcessCruUsers();
    }
}

