/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.actions;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crucible.actions.BaseAction;
import com.atlassian.fecru.actions.Material;
import com.atlassian.xwork.RequireSecurityToken;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AboutBoxContentsAction
extends BaseAction {
    public static final String LICENSES_BOM_CSV = "/licenses-bom.csv";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Material> getLgplMaterials() {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)LICENSES_BOM_CSV, AboutBoxContentsAction.class);
        if (is == null) {
            Logs.APP_LOG.error((Object)"Couldn't find resource '/licenses-bom.csv'");
            return Collections.emptyList();
        }
        String bomContents = null;
        try {
            bomContents = IOUtils.toString((InputStream)is);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Error reading '/licenses-bom.csv'", (Throwable)e2);
            List<Material> list = Collections.emptyList();
            return list;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        ArrayList materials = Lists.newArrayList();
        bomContents = bomContents.replaceAll("\\r", "\n");
        String[] materialLines = bomContents.split("\\n");
        for (String materialLine : materialLines = StringUtils.stripAll((String[])materialLines)) {
            if (materialLine.startsWith("#") || !materialLine.contains("GNU Lesser General Public License") && !materialLine.contains("GNU Lesser General Public Licence")) continue;
            String[] materialInfo = materialLine.split(",", -1);
            if (materialInfo.length != 5 && materialInfo.length != 6) {
                Logs.APP_LOG.info((Object)String.format("Could not parse license info line: %s", materialLine));
                continue;
            }
            materialInfo = StringUtils.stripAll((String[])materialInfo);
            String libraryName = materialInfo[0];
            String mavenInfo = materialInfo[1];
            String url = materialInfo[3];
            if (StringUtils.isEmpty((String)(libraryName + mavenInfo + url))) continue;
            String license = materialInfo[2];
            String artifactType = materialInfo[4];
            materials.add(new Material(libraryName, mavenInfo, license, url, artifactType));
        }
        return materials;
    }

    @RequireSecurityToken(value=false)
    public String execute() throws Exception {
        return super.execute();
    }
}

