/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.wikirenderer.macro;

import com.atlassian.fisheye.web.NavBuilder;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.base.Strings;
import java.util.Map;

public class ChangesetLinkMacro
extends BaseMacro {
    public static final String ID = "id";
    public static final String REPOSITORY = "rep";
    public static final String NAME = "cs";
    public static final String LINK_TITLE = "title";
    private boolean renderLink;

    public ChangesetLinkMacro(boolean renderLink) {
        this.renderLink = renderLink;
    }

    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String linkValue;
        String id = StringUtil.trim((String)parameters.get(ID));
        String repository = StringUtil.trim((String)parameters.get(REPOSITORY));
        String link = StringUtil.trim((String)parameters.get(LINK_TITLE));
        if (Strings.isNullOrEmpty((String)id) || Strings.isNullOrEmpty((String)repository)) {
            throw new MacroException("Invalid arguments to cs macro");
        }
        if (Strings.isNullOrEmpty((String)link)) {
            link = id;
        }
        if (this.renderLink) {
            String href = NavBuilder.changesetAbs(null, repository, id);
            linkValue = "<span class='cslinkspan'><a href='" + href + "'>" + HtmlEscaper.escapeAll((String)link, (boolean)renderContext.getRenderMode().preserveEntities()) + "<input type='hidden' value='" + ExpressionUtil.escapeJavaScriptString(id) + "' class='csid'>" + "<input type='hidden' value='" + ExpressionUtil.escapeJavaScriptString(repository) + "' class='repname'>" + "</a>" + "</span>";
        } else {
            linkValue = HtmlEscaper.escapeAll((String)link, (boolean)renderContext.getRenderMode().preserveEntities());
        }
        return linkValue;
    }
}

