/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.wikirenderer;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.web.NavBuilder;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.BaseLink;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.v2.components.BackslashEscapeRendererComponent;

public class FishEyeUserLink
extends BaseLink {
    private final String username;

    public FishEyeUserLink(RenderContext context, GenericLinkParser parser, FecruUser user) {
        super(parser);
        this.username = user.getUsername();
        String linkText = parser.getNotLinkBody();
        if (!linkText.startsWith("~")) {
            throw new IllegalArgumentException("Link text '" + linkText + "' is not a user link.");
        }
        this.linkBody = BackslashEscapeRendererComponent.escapeWiki((String)user.getDisplayName());
        this.url = context.getBaseUrl() + "/" + NavBuilder.user(this.username);
    }

    public String getLinkAttributes() {
        return super.getLinkAttributes() + " class=\"user userorcommitter\" data-username=\"" + this.username + "\"";
    }
}

