/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.wikirenderer;

import com.atlassian.crucible.wikirenderer.CrucibleLinkResolver;
import com.atlassian.crucible.wikirenderer.CrucibleRendererComponent;
import com.atlassian.crucible.wikirenderer.CrucibleWikiLink;
import com.atlassian.crucible.wikirenderer.CrucibleWikiRendererConfiguration;
import com.atlassian.crucible.wikirenderer.macro.ChangesetLinkMacro;
import com.atlassian.crucible.wikirenderer.macro.PreserveOldFormatMacro;
import com.atlassian.fisheye.plugin.web.helpers.WikiRenderer;
import com.atlassian.fisheye.web.NavBuilder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.renderer.DefaultIconManager;
import com.atlassian.renderer.IconManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.renderer.embedded.DefaultEmbeddedResourceRenderer;
import com.atlassian.renderer.embedded.EmbeddedResourceRenderer;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.Renderer;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.V2LinkRenderer;
import com.atlassian.renderer.v2.V2Renderer;
import com.atlassian.renderer.v2.V2RendererFacade;
import com.atlassian.renderer.v2.V2SubRenderer;
import com.atlassian.renderer.v2.components.BackslashEscapeRendererComponent;
import com.atlassian.renderer.v2.components.EmbeddedImageRendererComponent;
import com.atlassian.renderer.v2.components.HtmlEntityRendererComponent;
import com.atlassian.renderer.v2.components.HtmlEscapeRendererComponent;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.v2.components.LinkRendererComponent;
import com.atlassian.renderer.v2.components.MacroRendererComponent;
import com.atlassian.renderer.v2.components.TokenRendererComponent;
import com.atlassian.renderer.v2.components.block.BlockRenderer;
import com.atlassian.renderer.v2.components.block.BlockRendererComponent;
import com.atlassian.renderer.v2.components.block.BlockquoteBlockRenderer;
import com.atlassian.renderer.v2.components.block.HeadingBlockRenderer;
import com.atlassian.renderer.v2.components.block.HorizontalRuleBlockRenderer;
import com.atlassian.renderer.v2.components.list.ListBlockRenderer;
import com.atlassian.renderer.v2.components.phrase.DashRendererComponent;
import com.atlassian.renderer.v2.components.phrase.EmoticonRendererComponent;
import com.atlassian.renderer.v2.components.phrase.ForceNewLineRendererComponent;
import com.atlassian.renderer.v2.components.phrase.NewLineRendererComponent;
import com.atlassian.renderer.v2.components.phrase.PhraseRendererComponent;
import com.atlassian.renderer.v2.components.table.TableBlockRenderer;
import com.atlassian.renderer.v2.macro.DefaultMacroManager;
import com.atlassian.renderer.v2.macro.Macro;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.user.UserManager;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="crucibleWikiRenderer")
@AvailableToPlugins(value=WikiRenderer.class)
public class CrucibleWikiRenderer
implements WikiRenderer {
    private final V2RendererFacade renderer;
    private final RootConfig rootConfig;
    private LinkerService linkerService;
    private final UserManager userManager;

    @Autowired
    public CrucibleWikiRenderer(RootConfig rootConfig, LinkerService linkerService, UserManager userManager) {
        this(new CrucibleWikiRendererConfiguration(), rootConfig, linkerService, userManager);
    }

    public CrucibleWikiRenderer(RendererConfiguration config, RootConfig rootConfig, LinkerService linkerService, UserManager userManager) {
        this.rootConfig = rootConfig;
        this.linkerService = linkerService;
        this.userManager = userManager;
        this.renderer = this.createV2RendererFacade(config);
    }

    public String render(CharSequence wikiText) {
        return this.render(wikiText, this.makeRenderContext());
    }

    public String render(CharSequence wikiText, RenderContext renderContext) {
        return this.renderer.convertWikiToXHtml(renderContext, wikiText.toString());
    }

    public String renderPlain(CharSequence wikiText) {
        return this.renderPlain(wikiText, this.makeRenderContext());
    }

    public String renderPlain(CharSequence wikiText, RenderContext renderContext) {
        return this.renderer.convertWikiToText(renderContext, wikiText.toString());
    }

    public <T extends RenderContext> T setupRenderContextProperties(T renderContext) {
        String siteURL = NavBuilder.getSiteUrl();
        String webContext = this.rootConfig.getContextPath();
        renderContext.setBaseUrl(siteURL);
        renderContext.setSiteRoot(webContext);
        renderContext.setImagePath(siteURL + "/static/" + FisheyeVersionInfo.BUILD_STAMP + "/2static/images/wiki");
        renderContext.pushRenderMode(RenderMode.suppress((long)2048L));
        return renderContext;
    }

    private RenderContext makeRenderContext() {
        return this.setupRenderContextProperties(new RenderContext());
    }

    private V2RendererFacade createV2RendererFacade(RendererConfiguration config) {
        V2Renderer renderer = new V2Renderer();
        V2SubRenderer subRenderer = new V2SubRenderer();
        DefaultIconManager defaultIconManager = new DefaultIconManager();
        V2RendererFacade rendererFacade = new V2RendererFacade();
        subRenderer.setRenderer((Renderer)renderer);
        rendererFacade.setRendererConfiguration(config);
        rendererFacade.setRenderer((Renderer)renderer);
        rendererFacade.setDefaultEmbeddedRenderer((EmbeddedResourceRenderer)new DefaultEmbeddedResourceRenderer());
        rendererFacade.setDefaultLinkRenderer((LinkRenderer)new V2LinkRenderer((SubRenderer)subRenderer, (IconManager)defaultIconManager, config){

            public String renderLink(Link link, RenderContext renderContext) {
                CrucibleWikiLink cruLink;
                String spanClass;
                if (link instanceof CrucibleWikiLink && (spanClass = LinkerFactory.getPopupLinkSpanClass((cruLink = (CrucibleWikiLink)link).getUrlRegion())) != null) {
                    StringBuilder b2 = new StringBuilder();
                    b2.append("<span class=").append("\"").append(spanClass).append("\">").append(super.renderLink(link, renderContext)).append("</span>");
                    return b2.toString();
                }
                return super.renderLink(link, renderContext);
            }
        });
        this.setupComponents(renderer, subRenderer, defaultIconManager);
        return rendererFacade;
    }

    private void setupComponents(V2Renderer renderer, V2SubRenderer subRenderer, DefaultIconManager defaultIconManager) {
        CrucibleRendererComponent crucibleRendererComponent = new CrucibleRendererComponent(this.linkerService);
        DefaultMacroManager defaultMacroManager = new DefaultMacroManager(subRenderer);
        defaultMacroManager.unregisterMacro("html");
        defaultMacroManager.registerMacro("cs", (Macro)new ChangesetLinkMacro(this.rootConfig.isFishEye()));
        defaultMacroManager.registerMacro("preserve-old", (Macro)new PreserveOldFormatMacro(crucibleRendererComponent));
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(new MacroRendererComponent((MacroManager)defaultMacroManager, (SubRenderer)subRenderer));
        components.add(new BlockRendererComponent((SubRenderer)subRenderer, this.createBlockRenderers()));
        components.add(new LinkRendererComponent((LinkResolver)new CrucibleLinkResolver(this.linkerService, this.userManager)));
        components.add((Object)new QuoteEscapingHtmlEscapeRendererComponent());
        components.add(new BackslashEscapeRendererComponent());
        components.add(new HtmlEntityRendererComponent());
        components.add(new DashRendererComponent());
        components.add(new EmbeddedImageRendererComponent());
        components.add(crucibleRendererComponent);
        components.add(new EmoticonRendererComponent((IconManager)defaultIconManager));
        components.add(PhraseRendererComponent.getDefaultRenderer((String)"strong"));
        components.add(PhraseRendererComponent.getDefaultRenderer((String)"superscript"));
        components.add(PhraseRendererComponent.getDefaultRenderer((String)"subscript"));
        components.add(PhraseRendererComponent.getDefaultRenderer((String)"emphasis"));
        components.add(PhraseRendererComponent.getDefaultRenderer((String)"deleted"));
        components.add(PhraseRendererComponent.getDefaultRenderer((String)"citation"));
        components.add(PhraseRendererComponent.getDefaultRenderer((String)"inserted"));
        components.add(PhraseRendererComponent.getDefaultRenderer((String)"monospaced"));
        components.add(new ForceNewLineRendererComponent());
        components.add(new NewLineRendererComponent());
        components.add(new TokenRendererComponent((SubRenderer)subRenderer));
        renderer.setComponents(components);
    }

    private ArrayList<BlockRenderer> createBlockRenderers() {
        ArrayList<BlockRenderer> blockRenderers = new ArrayList<BlockRenderer>();
        blockRenderers.add((BlockRenderer)new HeadingBlockRenderer());
        blockRenderers.add((BlockRenderer)new BlockquoteBlockRenderer());
        blockRenderers.add((BlockRenderer)new HorizontalRuleBlockRenderer());
        blockRenderers.add((BlockRenderer)new ListBlockRenderer());
        blockRenderers.add((BlockRenderer)new TableBlockRenderer());
        return blockRenderers;
    }

    private static class QuoteEscapingHtmlEscapeRendererComponent
    extends HtmlEscapeRendererComponent {
        private QuoteEscapingHtmlEscapeRendererComponent() {
        }

        public String render(String wiki, RenderContext context) {
            return HtmlEscaper.escapeAll((String)wiki, (boolean)context.getRenderMode().preserveEntities());
        }
    }
}

