/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.wikirenderer;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.tags.UserTextRendererTag;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionListRenderer;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;

public class CrucibleRendererComponent
implements RendererComponent {
    private static Pattern singleTokenPattern = Pattern.compile(Pattern.quote(RenderedContentStore.BLOCK_TOKEN) + "[0-9]+" + Pattern.quote(RenderedContentStore.BLOCK_TOKEN));
    private LinkerService linkerService;

    public CrucibleRendererComponent(LinkerService linkerService) {
        this.linkerService = linkerService;
    }

    public boolean shouldRender(RenderMode renderMode) {
        return renderMode.renderLinks();
    }

    public String render(String wiki, RenderContext context) {
        if (this.isSingleToken(wiki)) {
            return wiki;
        }
        StringWriter stringWriter = new StringWriter();
        WikiBridgingUserTextRendererTag userTextRenderer = this.createUserTextRendererTag(wiki, context, stringWriter);
        try {
            userTextRenderer.doTag();
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"error during user text rendering.", (Throwable)e2);
            return "error during user text rendering, see logs for details.";
        }
        return ((Object)stringWriter).toString();
    }

    private boolean isSingleToken(String wiki) {
        return singleTokenPattern.matcher(wiki).matches();
    }

    private WikiBridgingUserTextRendererTag createUserTextRendererTag(String wikiText, RenderContext context, Writer stringWriter) {
        return new WikiBridgingUserTextRendererTag(wikiText, context, stringWriter, this.linkerService);
    }

    private static class WikiBridgingUserTextRendererTag
    extends UserTextRendererTag {
        private final Writer stringWriter;
        private RenderContext renderContext;
        private Linker linker;
        private LinkerService linkerService;

        public WikiBridgingUserTextRendererTag(String wikiText, RenderContext renderContext, Writer stringWriter, LinkerService linkerService) {
            this.stringWriter = stringWriter;
            this.renderContext = renderContext;
            this.linkerService = linkerService;
            if (renderContext instanceof CrucibleRenderContext) {
                String eol;
                Linker linkerParam;
                String repName;
                String space;
                CrucibleRenderContext crucibleRenderContext = (CrucibleRenderContext)renderContext;
                Review review = crucibleRenderContext.getParam(CrucibleRenderContext.Params.Review, Review.class);
                if (review != null) {
                    this.setReview(review);
                }
                if (!Strings.isNullOrEmpty((String)(space = crucibleRenderContext.getParam(CrucibleRenderContext.Params.Space, String.class)))) {
                    this.setSpace(space);
                }
                if (!Strings.isNullOrEmpty((String)(repName = crucibleRenderContext.getParam(CrucibleRenderContext.Params.RepoName, String.class)))) {
                    this.setRepname(repName);
                }
                if ((linkerParam = crucibleRenderContext.getParam(CrucibleRenderContext.Params.Linker, Linker.class)) != null) {
                    this.linker = linkerParam;
                }
                if (!Strings.isNullOrEmpty((String)(eol = crucibleRenderContext.getParam(CrucibleRenderContext.Params.Eol, String.class)))) {
                    this.setEol(eol);
                }
                this.setAllowConsecutiveNewline(crucibleRenderContext.getParam(CrucibleRenderContext.Params.AllowConsecutiveNewline, Boolean.class));
            }
            this.setText(wikiText);
            this.setPrintFirstSpaceAsSpace(true);
            this.setPrintLastSpaceAsSpace(false);
            this.setEnableLinks(true);
            this.setEscapeHTML(false);
        }

        @Override
        protected Writer getOut() {
            return this.stringWriter;
        }

        @Override
        protected Linker getLinker() {
            if (this.linker == null) {
                return super.getLinker();
            }
            return this.linker;
        }

        @Override
        protected LinkerService getLinkerService() {
            return this.linkerService;
        }

        @Override
        protected RegionListRenderer getRegionRenderer() {
            final RegionListRenderer actualRenderer = super.getRegionRenderer();
            return new RegionListRenderer(){
                private StringWriter tokenizeBuffer = new StringWriter();

                @Override
                public void renderUpToRegionStart(Region region, Writer writer, CharSequence chars) throws IOException {
                    actualRenderer.renderUpToRegionStart(region, writer, chars);
                }

                @Override
                public boolean renderRegionStart(Region region, Writer writer) throws IOException {
                    return actualRenderer.renderRegionStart(region, this.tokenizeBuffer);
                }

                @Override
                public boolean renderRegionEnd(Region region, Writer writer) throws IOException {
                    boolean shouldTokenize = actualRenderer.renderRegionEnd(region, this.tokenizeBuffer);
                    if (shouldTokenize) {
                        writer.write(renderContext.addRenderedContent((Object)this.tokenizeBuffer.toString(), TokenType.INLINE_BLOCK));
                        this.tokenizeBuffer = new StringWriter();
                    }
                    return shouldTokenize;
                }

                @Override
                public void renderUpToRegionEnd(Region region, Writer writer, CharSequence chars) throws IOException {
                    this.format(this.tokenizeBuffer, chars);
                }

                @Override
                public void renderEnd(Writer writer, CharSequence charSequence) throws IOException {
                    writer.write(this.tokenizeBuffer.toString());
                    actualRenderer.renderEnd(writer, charSequence);
                }
            };
        }
    }
}

