/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.wikirenderer;

import com.atlassian.crucible.wikirenderer.CrucibleRenderContext;
import com.atlassian.crucible.wikirenderer.CrucibleWikiLink;
import com.atlassian.crucible.wikirenderer.FishEyeUserLink;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.links.UnresolvedLink;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.RegionListVisitor;
import com.cenqua.fisheye.user.UserManager;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CrucibleLinkResolver
implements LinkResolver {
    private final LinkerService linkerService;
    private final UserManager userManager;

    public CrucibleLinkResolver(LinkerService linkerService, UserManager userManager) {
        this.linkerService = linkerService;
        this.userManager = userManager;
    }

    public Link createLink(RenderContext context, String linkText) {
        String repositoryName;
        GenericLinkParser linkParser = new GenericLinkParser(linkText);
        String linkString = linkParser.getNotLinkBody();
        Review review = null;
        if (context instanceof CrucibleRenderContext) {
            CrucibleRenderContext cruContext = (CrucibleRenderContext)context;
            review = cruContext.getParam(CrucibleRenderContext.Params.Review, Review.class);
        }
        if (linkText.startsWith("~")) {
            String username = linkText.substring(1);
            FecruUser user = this.userManager.getLicensedUser(username);
            if (user != null) {
                return new FishEyeUserLink(context, linkParser, user);
            }
            return new UnresolvedLink(linkText);
        }
        Source source = null;
        String crucibleProjectKey = null;
        if (review != null && StringUtils.isNotEmpty((String)(repositoryName = review.getProject().getDefaultRepositoryName()))) {
            SourceFactory sourceFactory = SpringContext.getComponent(SourceFactory.class, "sourceFactory");
            EffectiveUserProvider effectiveUserProvider = SpringContext.getComponent(EffectiveUserProviderImpl.class, "effectiveUserProvider");
            source = sourceFactory.getSource(repositoryName, effectiveUserProvider.getEffectivePrincipal());
            crucibleProjectKey = review.getProject().getProjKey();
        }
        RegionList regionList = new RegionList();
        regionList.add(new Region(0, linkString.length(), Collections.singletonMap("findlinks", "true")));
        this.getLinkerService().getLinker(source, crucibleProjectKey).insertLinks(linkString, regionList);
        LinkExtractingRegionListVisitor linkExtractingRegionListVisitor = new LinkExtractingRegionListVisitor(linkParser);
        try {
            regionList.visitRegions(linkExtractingRegionListVisitor);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Error visiting regions", (Throwable)e2);
            return new UnresolvedLink(linkText);
        }
        Link link = linkExtractingRegionListVisitor.createLink();
        return link;
    }

    public List extractLinkTextList(String pageContent) {
        throw new UnsupportedOperationException("extractLinkTextList should not be used in Crucible wiki rendering");
    }

    public List extractLinks(RenderContext context, String text) {
        throw new UnsupportedOperationException("extractLinks should not be used in Crucible wiki rendering");
    }

    public String removeLinkBrackets(String linkText) {
        throw new UnsupportedOperationException("removeLinkBrackets should not be used in Crucible wiki rendering");
    }

    private LinkerService getLinkerService() {
        return this.linkerService;
    }

    private static class LinkExtractingRegionListVisitor
    implements RegionListVisitor {
        private final GenericLinkParser linkParser;
        private Region regionOfInterest;

        public LinkExtractingRegionListVisitor(GenericLinkParser linkParser) {
            this.linkParser = linkParser;
        }

        @Override
        public void start() throws IOException {
        }

        @Override
        public void regionStart(Region region) throws IOException {
            if (region.getPropertyValue("href") != null) {
                this.regionOfInterest = this.regionOfInterest == null ? region : this.largerOf(this.regionOfInterest, region);
            }
        }

        private Region largerOf(Region regionA, Region regionB) {
            if (regionA.nests(regionB)) {
                return regionA;
            }
            return regionA.length() >= regionB.length() ? regionA : regionB;
        }

        @Override
        public void regionEnd(Region region) throws IOException {
        }

        @Override
        public void end() throws IOException {
        }

        public Link createLink() {
            Object link = this.regionOfInterest == null || this.regionOfInterest.getPropertyValue("href") == null ? new UnresolvedLink(this.linkParser.getOriginalLinkText()) : new CrucibleWikiLink(this.regionOfInterest, this.linkParser);
            return link;
        }
    }
}

