/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc.util;

import com.atlassian.crucible.configuration.metrics.FieldDefinition;
import com.atlassian.crucible.configuration.metrics.MetricsConfig;
import com.atlassian.crucible.spi.data.CustomFieldDefData;
import com.atlassian.crucible.spi.data.CustomFieldValue;
import com.atlassian.crucible.spi.data.CustomFieldValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetricsUtil {
    private MetricsUtil() {
    }

    public static List<CustomFieldDefData> toSPI(MetricsConfig config, int version) {
        ArrayList<CustomFieldDefData> metadata = new ArrayList<CustomFieldDefData>();
        Map<String, FieldDefinition> commentFields = config.getCommentFields();
        for (String s2 : commentFields.keySet()) {
            FieldDefinition fieldDefinition = commentFields.get(s2);
            CustomFieldDefData field = new CustomFieldDefData();
            field.setConfigVersion(version);
            field.setType(MetricsUtil.getCustomFieldType(fieldDefinition.getType(), fieldDefinition.getName()));
            field.setName(fieldDefinition.getName());
            field.setLabel(fieldDefinition.getLabel());
            field.setDefaultValue(new CustomFieldValue(fieldDefinition.getDefaultValueKey(), fieldDefinition.getDefaultValue()));
            Set<String> names = fieldDefinition.getNamedValueNames();
            for (String name : names) {
                field.getValues().add(new CustomFieldValue(name, fieldDefinition.getNamedValue(name)));
            }
            metadata.add(field);
        }
        return metadata;
    }

    private static CustomFieldValueType getCustomFieldType(int typeValue, String name) {
        CustomFieldValueType type;
        switch (typeValue) {
            case -1: {
                type = CustomFieldValueType.NOT_SET;
                break;
            }
            case 0: {
                type = CustomFieldValueType.STRING;
                break;
            }
            case 1: {
                type = CustomFieldValueType.INTEGER;
                break;
            }
            case 2: {
                type = CustomFieldValueType.BOOLEAN;
                break;
            }
            case 3: {
                type = CustomFieldValueType.DATE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Custom field " + name + " with unknown type code:" + typeValue);
            }
        }
        return type;
    }
}

