/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc.util;

import com.atlassian.crucible.spi.services.FileData;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileDataBuilder {
    private String name;
    private String contentType;
    private String charSet;
    private String description;
    private ByteSource contentSupplier;

    FileDataBuilder() {
    }

    public FileDataBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FileDataBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public FileDataBuilder charSet(String charSet) {
        this.charSet = charSet;
        return this;
    }

    public FileDataBuilder description(String description) {
        this.description = description;
        return this;
    }

    public FileDataBuilder content(ByteSource contentSupplier) {
        this.contentSupplier = contentSupplier;
        return this;
    }

    public FileDataBuilder content(URL contentUrl) {
        this.contentSupplier = Resources.asByteSource((URL)contentUrl);
        return this;
    }

    public FileData build() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"File name cannot be empty");
        Preconditions.checkArgument((this.contentSupplier != null ? 1 : 0) != 0, (Object)"File content supplier cannot be null");
        return new FileDataWithSupplier(this.name, this.contentType, this.charSet, this.description, this.contentSupplier);
    }

    public static FileDataBuilder create() {
        return new FileDataBuilder();
    }

    public static FileDataBuilder create(URL contentUrl) {
        return FileDataBuilder.create().name(FileDataBuilder.basename(contentUrl.getPath())).content(contentUrl);
    }

    public static FileDataBuilder create(File file) {
        ByteSource contentSupplier = Files.asByteSource((File)file);
        return FileDataBuilder.create().name(file.getName()).content(contentSupplier);
    }

    public static FileDataBuilder create(String content) {
        return FileDataBuilder.create().content(ByteSource.wrap((byte[])content.getBytes(Charsets.UTF_8))).charSet(Charsets.UTF_8.name());
    }

    private static String basename(String path) {
        int slashIdx = path.lastIndexOf(47);
        return slashIdx != -1 ? path.substring(slashIdx + 1) : path;
    }

    static class FileDataWithSupplier
    implements FileData {
        private final String name;
        private final String contentType;
        private final String charSet;
        private final String description;
        private final ByteSource contentSupplier;

        FileDataWithSupplier(String name, String contentType, String charSet, String description, ByteSource contentSupplier) {
            this.name = name;
            this.contentType = contentType;
            this.charSet = charSet;
            this.description = description;
            this.contentSupplier = contentSupplier;
        }

        public void getContents(OutputStream out) throws IOException, IllegalStateException {
            try (InputStream is = this.contentSupplier.openBufferedStream();){
                ByteStreams.copy((InputStream)is, (OutputStream)out);
            }
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return this.name;
        }

        public String getCharSet() {
            return this.charSet;
        }

        public String getDescription() {
            return this.description;
        }

        public void close() {
        }
    }
}

