/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc.data;

import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class LoginResult {
    public String token;
    public String error;

    public LoginResult() {
    }

    LoginResult(String token, String error) {
        this.token = token;
        this.error = error;
    }

    public static LoginResult error(String message) {
        return new LoginResult(null, message);
    }

    public static LoginResult token(String token) {
        return new LoginResult(token, null);
    }

    public static LoginResult attemptLogin(HttpServletRequest request, HttpServletResponse response, String userName, String password, String urlPrefix, UserManager userManager) throws LicensePolicyException {
        UserLogin user = userManager.login(request, response, userName, password, false);
        if (user == null) {
            if (userManager.hasUserExceededLoginAttempts(userName)) {
                return LoginResult.error("Attempt to log in user '" + userName + "' failed. The maximum number of failed login attempts has been reached. Please log into the web application through the web interface to reset the number of failed login attempts.");
            }
            return LoginResult.error("Authentication failed. Please check that the username and password provided are correct.");
        }
        LoginCookie lc = userManager.preCookUrl(request, urlPrefix, true);
        return LoginResult.token(lc.getLoginCookieToken().encode());
    }
}

