/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.atlassian.crucible.spi.services.FileData;
import com.cenqua.fisheye.io.IOHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;

public class FileDataImpl
implements FileData {
    private final FileItem item;
    private final InputStream stream;
    private final String charSet;
    private final String description;
    private boolean written = false;

    public FileDataImpl(FileItem item, String charSet, String description) throws IOException {
        this.item = item;
        this.charSet = charSet;
        this.description = description;
        this.stream = item.getInputStream();
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public void getContents(OutputStream out) throws IOException, IllegalStateException {
        if (this.written) {
            throw new IllegalStateException("The contents have already been written and can only be written once.");
        }
        IOHelper.copyStream(this.stream, out);
        this.written = true;
    }

    public String getContentType() {
        return this.item.getContentType();
    }

    public String getName() {
        return this.item.getName();
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String getDescription() {
        return this.description;
    }

    public void close() {
        this.item.delete();
    }
}

