/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.atlassian.crucible.spi.rpc.LastChange;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.cenqua.crucible.hibernate.EmptyHibernateListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import org.hibernate.type.Type;

public class DatabaseChange
implements LastChange {
    private static final ResettableLazyReference<LastChange.LastChangeTag> lastModified = new ResettableLazyReference<LastChange.LastChangeTag>(){

        protected LastChange.LastChangeTag create() throws Exception {
            long now = System.currentTimeMillis();
            return new LastChange.LastChangeTag(new Date(now), String.format("%d-%d", now, System.nanoTime()));
        }
    };

    @Override
    public LastChange.LastChangeTag getLastChange() {
        return (LastChange.LastChangeTag)lastModified.get();
    }

    private static void update() {
        lastModified.reset();
    }

    public static class HibernateUpdateListener
    extends EmptyHibernateListener {
        @Override
        public void onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            DatabaseChange.update();
        }

        @Override
        public void onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            DatabaseChange.update();
        }

        @Override
        public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            DatabaseChange.update();
        }

        @Override
        public void onCollectionRecreate(Object collection, Serializable key) {
            DatabaseChange.update();
        }

        @Override
        public void onCollectionRemove(Object collection, Serializable key) {
            DatabaseChange.update();
        }

        @Override
        public void onCollectionUpdate(Object collection, Serializable key) {
            DatabaseChange.update();
        }

        @Override
        public void postFlush(Iterator entities) {
            DatabaseChange.update();
        }

        static {
            DatabaseChange.update();
        }
    }
}

