/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.atlassian.crucible.spi.rpc.ConditionalGet;
import com.atlassian.crucible.spi.rpc.LastChange;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.google.common.collect.Lists;
import java.util.List;

public abstract class CompoundConditionalGet<T>
implements ConditionalGet<T> {
    private final List<LastChange> changes;

    public CompoundConditionalGet(LastChange change, LastChange ... otherChanges) {
        this.changes = Lists.asList((Object)change, (Object[])otherChanges);
    }

    @Override
    public LastChange.LastChangeTag getLastChange() throws NotFoundException {
        long newest = Long.MIN_VALUE;
        LastChange.LastChangeTag result = null;
        for (LastChange change : this.changes) {
            LastChange.LastChangeTag changeTag = change.getLastChange();
            if (changeTag.getDate().getTime() <= newest) continue;
            result = changeTag;
            newest = changeTag.getDate().getTime();
        }
        return result;
    }
}

