/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.data.UserProfileData;
import com.atlassian.crucible.spi.impl.DefaultSPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.crucible.spi.services.ServerException;
import com.atlassian.crucible.spi.services.UserService;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userService")
@AvailableToPlugins
public class DefaultUserService
implements UserService {
    private final EffectiveUserProvider effectiveUserProvider;
    private final UserManager userManager;
    private final UserProfileManager userProfileManager;
    private final CommitterUserMappingManager committerMappingManager;
    private final ConfigDocument.Config config;
    private final RootConfig rootConfig;
    private final RepositoryManager repositoryManager;
    private final SPIUserUtils spiUserUtils;
    private final LicenseManager licenseManager;

    @Autowired
    public DefaultUserService(EffectiveUserProvider effectiveUserProvider, UserManager userManager, CommitterUserMappingManager mappingManager, UserProfileManager userProfileManager, ConfigDocument.Config config, RootConfig rootConfig, RepositoryManager repositoryManager, SPIUserUtils spiUserUtils, LicenseManager licenseManager) {
        this.effectiveUserProvider = effectiveUserProvider;
        this.userManager = userManager;
        this.committerMappingManager = mappingManager;
        this.userProfileManager = userProfileManager;
        this.config = config;
        this.rootConfig = rootConfig;
        this.repositoryManager = repositoryManager;
        this.spiUserUtils = spiUserUtils;
        this.licenseManager = licenseManager;
    }

    public List<UserData> getAllUsers() {
        this.requireAuthentication();
        SecurityType security = this.config.getSecurity();
        if (this.effectiveUserProvider.isAnonymous() && security.isSetAllowUserListsAnon() && !security.getAllowUserListsAnon()) {
            throw new NotPermittedException("You must be logged in to access this resource.");
        }
        return this.userManager.getLicensedUsers().stream().map(DefaultSPIUserUtils.USER_TO_USERDATA_FUNCTION).collect(Collectors.toList());
    }

    public int getLicensedUserCount() {
        this.requireAuthentication();
        return this.licenseManager.getLicensedUsersCount();
    }

    public int getActiveUserCount() throws ServerException {
        return this.getLicensedUserCount();
    }

    public UserData getUser(String userName) {
        this.requireAuthentication();
        FecruUser user = this.userManager.getLicensedUser(userName);
        if (user == null) {
            throw new NotFoundException("No user named '" + userName + "'");
        }
        return this.spiUserUtils.createUserData(user);
    }

    public UserProfileData getUserProfile(String userName) {
        Principal loggedInUser = this.effectiveUserProvider.getEffectivePrincipal();
        if (Principal.Anonymous.isAnon((Principal)loggedInUser)) {
            throw new NotPermittedException("You must be logged in to access this resource.");
        }
        boolean showOnlyBasicDetails = !Principal.SuperUser.isSuperUser((Principal)loggedInUser) && !loggedInUser.getUserName().equals(userName) && !this.userManager.hasSysAdminPrivileges(loggedInUser.getUserName());
        FecruUser user = this.userManager.getLicensedUser(userName);
        if (user == null) {
            throw new NotFoundException("No user named '" + userName + "'");
        }
        return this.makeUserProfileData(user, showOnlyBasicDetails);
    }

    public UserData getMappedUser(String repository, String committer) {
        this.requireAuthentication();
        Principal loggedInUser = this.effectiveUserProvider.getEffectivePrincipal();
        RepositoryHandle repo = this.repositoryManager.getRepository(repository);
        if (repo == null) {
            throw new NotFoundException("The repository '" + repository + "' does not exist.");
        }
        if (!this.userManager.hasPermissionToAccess(loggedInUser, repo)) {
            throw new NotPermittedException("You do not have authorization to access this resource.");
        }
        CrossRepLuceneIndex crossRepLuceneIndex = this.rootConfig.getCrossRepLuceneIndex();
        if (!ChangesetStatsCalculator.committerExists(crossRepLuceneIndex.getConnection(), repository, committer)) {
            throw new NotFoundException("Committer '" + committer + "' does not exist in repository '" + repository + "'");
        }
        FecruUser user = this.committerMappingManager.getUserForCommitter(repository, committer);
        if (user == null) {
            throw new NotFoundException("No mapping found for committer '" + committer + " in repository '" + repository + "'");
        }
        return this.spiUserUtils.createUserData(user);
    }

    private UserProfileData makeUserProfileData(FecruUser user, boolean showBasicDetails) {
        UserProfileData data;
        UserData userData = this.spiUserUtils.createUserData(user);
        String avatarUrl = AvatarTypeInfo.getFullAvatarUrl(user, null);
        if (showBasicDetails) {
            data = new UserProfileData(userData, null, null, avatarUrl, null);
        } else {
            TimeZone timeZone = AppConfig.getUserTimeZone(user.getUsername());
            String email = user.getEmail();
            Multimap<String, String> committers = this.committerMappingManager.getAllCommittersForUser(user.getUsername());
            Map mappedCommitters = Maps.transformValues((Map)committers.asMap(), (Function)new Function<Collection<String>, List<String>>(){

                public List<String> apply(@Nullable Collection<String> input) {
                    return ImmutableList.copyOf(input);
                }
            });
            data = new UserProfileData(userData, email, timeZone, avatarUrl, mappedCommitters);
            UserProfile profile = this.userProfileManager.getProfile(user.getUsername());
            data.setPreferences(profile.getChangesetsPerPage(), profile.getIdeConnectorPort(), profile.getMaxFilesPerChangeset(), profile.getTabwidth(), profile.isEnableIde(), profile.isHtmlEmailFormat(), profile.isNightlyWatchMode(), profile.getContext(), profile.getUploadType(), profile.getUploadMethod(), profile.getUploadCharset());
        }
        return data;
    }

    private void requireAuthentication() throws NotPermittedException {
        boolean anonymousAllowed;
        SecurityType security = this.config.getSecurity();
        boolean bl = anonymousAllowed = security.isSetAllowCruAnon() ? security.getAllowCruAnon() : security.getAllowAnon();
        if (!anonymousAllowed && this.effectiveUserProvider.isAnonymous()) {
            throw new NotPermittedException("You must be logged in to access this resource.");
        }
    }
}

