/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.services.SearchService;
import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.reviews.ReviewPermaIdResult;
import com.atlassian.fecru.search.reviews.ReviewPermaIdSearcher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.fisheye.web.NavBuilder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="searchService")
@AvailableToPlugins
public class DefaultSearchService
implements SearchService {
    private final EffectiveUserProvider effectiveUserProvider;
    private final ReviewManager reviewManager;
    private final ReviewPermaIdSearcher reviewPermaIdSearcher;
    private static final int MAX_REVIEWS = 200;

    @Autowired
    public DefaultSearchService(EffectiveUserProvider effectiveUserProvider, ReviewManager reviewManager, ReviewPermaIdSearcher reviewPermaIdSearcher) {
        this.effectiveUserProvider = effectiveUserProvider;
        this.reviewManager = reviewManager;
        this.reviewPermaIdSearcher = reviewPermaIdSearcher;
    }

    public List<ReviewData> searchForReviews(String term) {
        return this.searchForReviews(term, null);
    }

    public List<ReviewData> searchForReviews(String term, Integer limit) {
        return this.searchReviewForTerm(term, 0, limit, null);
    }

    public List<ReviewData> searchReviewForTerm(String term, Integer start, Integer limit, String projectKey) {
        if (Strings.isNullOrEmpty((String)term)) {
            return Collections.emptyList();
        }
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = 200;
        }
        SearchScope scope = SearchScope.builder().withFrom(start).withTo(start + limit).withProjectKey(projectKey).build();
        SearchResults results = this.reviewPermaIdSearcher.search(term, scope);
        ArrayList<Review> reviews = new ArrayList<Review>();
        for (ReviewPermaIdResult result : results) {
            reviews.add(this.reviewManager.getReviewByPermaId(result.getPermaId()));
        }
        return this.convertToReviewData(reviews);
    }

    public List<ReviewData> searchForReviewsByJiraKey(String key) {
        return this.convertToReviewData(Iterables.filter(this.reviewManager.getReviewsWithLinkedJira(key), (Predicate)new Predicate<Review>(){

            public boolean apply(Review review) {
                return ReviewUtil.principalCanDoReviewAction(DefaultSearchService.this.effectiveUserProvider.getEffectivePrincipal(), null, UserActionManager.ACTION_VIEW, review);
            }
        }));
    }

    private List<ReviewData> convertToReviewData(Iterable<Review> reviews) {
        ArrayList<ReviewData> reviewDataList = new ArrayList<ReviewData>();
        for (Review review : reviews) {
            ReviewData.Builder builder = new ReviewData.Builder().setPermaId(review.getPermaId()).setPermaIdHistory(review.getPermaIdHistoryAsStrings()).setProjectKey(review.getProject().getProjKey()).setName(review.getName()).setDescription(review.getDescription()).setAuthor(this.createUserData(review.getAuthor())).setModerator(this.createUserData(review.getModerator())).setCreator(this.createUserData(review.getCreator())).setSummary(review.getSummary()).setState(this.modelStateToDataState(review.getState())).setType(review.getType().getApiReviewType()).setAllowReviewersToJoin(Boolean.valueOf(review.isAllowReviewerToJoin())).setParentReview(review.getParentReview() == null ? null : new PermId(review.getParentReview().getPermaId())).setCreateDate(review.getCreateDate()).setCloseDate(review.getClosedDate()).setDueDate(review.getDueDate()).setReminderDate(review.getReminderDate()).setMetricsVersion(review.getMetricsVersion().intValue()).setJiraIssueKey(review.getJiraIssueKey());
            reviewDataList.add(builder.build());
        }
        return reviewDataList;
    }

    private UserData createUserData(FecruUser user) {
        return user == null ? null : new UserData(user.getUsername(), user.getDisplayName(), NavBuilder.user(null, user.getUsername()), this.getAvatarUrl(user));
    }

    private String getAvatarUrl(FecruUser user) {
        return AvatarTypeInfo.getFullAvatarUrl(user, null);
    }

    private ReviewData.State modelStateToDataState(State state) {
        ReviewData.State dataState = state.getStateType().getReviewDataState();
        if (dataState == null) {
            throw new RuntimeException("Unknown state " + state.getVerbage());
        }
        return dataState;
    }
}

