/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.crucible.spi.data.ProjectData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemRevisionData;
import com.atlassian.crucible.spi.data.ReviewerData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.data.ChangesetDataFE;
import com.atlassian.fisheye.spi.data.FileRevisionData;
import com.atlassian.fisheye.spi.data.FileRevisionKeyData;
import com.atlassian.fisheye.spi.data.RepositoryDataFE;
import com.atlassian.fisheye.spi.impl.RepositoryDataFactory;
import com.atlassian.fisheye.spi.services.IllegalRepositoryStateException;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.perforce.P4ChangeSet;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultSPIUtils
implements SPIUtils {
    private final RootConfig rootConfig;
    private final SourceFactory sourceFactory;
    private final SPIUserUtils spiUserUtils;
    private final RepositoryDataFactory repositoryDataFactory;
    private final PatchManager patchManager;

    @Autowired
    public DefaultSPIUtils(RootConfig rootConfig, SourceFactory sourceFactory, SPIUserUtils spiUserUtils, PatchManager patchManager) {
        this.rootConfig = rootConfig;
        this.sourceFactory = sourceFactory;
        this.spiUserUtils = spiUserUtils;
        this.patchManager = patchManager;
        this.repositoryDataFactory = new RepositoryDataFactory();
    }

    @Override
    public RepositoryDataFE createRepositoryDataFEFrom(RepositoryHandle repositoryHandle) {
        return this.repositoryDataFactory.fromHandle(repositoryHandle);
    }

    @Override
    public RepositoryHandle getRepositoryHandle(String repositoryName) {
        return this.rootConfig.getRepositoryManager().getRepository(repositoryName);
    }

    @Override
    public ProjectData createProjectData(Project p2) {
        return this.createProjectData(p2, true);
    }

    @Override
    public ProjectData createProjectData(Project p2, boolean isGetAllUsers) {
        return ProjectData.ProjectDataBuilder.builder().setId(p2.getId()).setName(p2.getName()).setProjectKey(p2.getProjKey()).setDefaultRepositoryName(p2.getDefaultRepositoryName()).setPermissionSchemeId(p2.getPermissionScheme().getId()).setPermissionSchemeName(p2.getPermissionScheme().getName()).setStoreRevisions(Boolean.valueOf(p2.isStoreRevisions())).setAllowReviewersToJoin(Boolean.valueOf(p2.isAllowReviewersToJoin())).setDefaultDuration(p2.getDefaultDuration()).setDefaultReviewerUsers(this.spiUserUtils.getNamesFromUsers(p2.getDefaultReviewers())).setDefaultModerator(p2.getDefaultModerator() == null ? null : p2.getDefaultModerator().getUsername()).setModeratorEnabled(Boolean.valueOf(p2.isModeratorEnabled())).setAllowedReviewerUsers(isGetAllUsers ? ImmutableList.copyOf(this.spiUserUtils.getAllowedReviewers(p2)) : null).setAllowedReviewerGroups((List)Lists.newArrayList(p2.getAllowedReviewerGroups())).setDefaultObjectives(p2.getDefaultObjectives()).build();
    }

    @Override
    public ChangesetDataFE createChangesetDataFEFrom(ChangeSet changeset) {
        Iterable<FileRevisionData> revisionDataIterator;
        Iterable<FileRevisionKeyData> revisionIterator;
        Set<String> branches = changeset.getBranches();
        try {
            revisionIterator = this.createFileRevisionKeyDataIterator(changeset);
            revisionDataIterator = this.createFileRevisionDataIterator(changeset);
        }
        catch (DbException e2) {
            throw new RuntimeException("Error accessing changeset " + changeset.getId(), e2);
        }
        String repositoryName = changeset.getRepName();
        String csid = changeset.getId();
        String displayId = changeset.getDisplayId();
        Date date = changeset.getDateValue();
        String author = changeset.getAuthor();
        String comment = changeset.getComment();
        LinkedHashSet<String> parents = new LinkedHashSet<String>(changeset.getParents());
        LinkedHashSet<String> children = new LinkedHashSet<String>(changeset.getChildren());
        Set<String> tags = changeset.getTags();
        Collection<String> fixes = null;
        if (changeset instanceof P4ChangeSet) {
            fixes = ((P4ChangeSet)changeset).getFixes();
        }
        boolean showTags = tags != null && tags.size() > 0;
        return new ChangesetDataFE(repositoryName, csid, displayId, date, author, comment, branches, showTags ? tags : null, parents, children, revisionIterator, revisionDataIterator, changeset.getRevisionInfosCount(), null, fixes);
    }

    @Override
    public Iterable<FileRevisionKeyData> createFileRevisionKeyDataIterator(final ChangeSet changeset) throws DbException {
        return new Iterable<FileRevisionKeyData>(){

            @Override
            public Iterator<FileRevisionKeyData> iterator() {
                return new Iterator<FileRevisionKeyData>(){
                    Iterator<? extends FileRevision> iterator;
                    {
                        this.iterator = changeset.getRevisionsIterable().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public FileRevisionKeyData next() {
                        FileRevision nextRev = this.iterator.next();
                        RevInfoKey revInfoKey = nextRev.getRevInfoKey();
                        return new FileRevisionKeyData(revInfoKey.getPath().getPath(), revInfoKey.getRev());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<FileRevisionData> createFileRevisionDataIterator(final ChangeSet changeset) throws DbException {
        return new Iterable<FileRevisionData>(){

            @Override
            public Iterator<FileRevisionData> iterator() {
                return new Iterator<FileRevisionData>(){
                    Iterator<? extends FileRevision> iterator;
                    {
                        this.iterator = changeset.getRevisionsIterable().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public FileRevisionData next() {
                        FileRevision nextRev = this.iterator.next();
                        return DefaultSPIUtils.this.createFileRevisionData(nextRev, changeset.getRepName());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private List<String> getAncestorRevisions(List<RevInfoKey> ancestors) {
        ArrayList<String> ancestorRevs = new ArrayList<String>();
        for (RevInfoKey key : ancestors) {
            ancestorRevs.add(key.getRev());
        }
        return ancestorRevs;
    }

    @Override
    public FileRevisionData createFileRevisionData(FileRevision fileRevision, String repositoryName) {
        String path = fileRevision.getPath().getPath();
        String rev = fileRevision.getRevision();
        String author = fileRevision.getAuthor();
        Date date = new Date(fileRevision.getDate());
        FileRevisionData.FileRevisionState fileRevisionState = fileRevision.isDead() ? FileRevisionData.FileRevisionState.REMOVED : (fileRevision.isAdded() ? FileRevisionData.FileRevisionState.ADDED : FileRevisionData.FileRevisionState.CHANGED);
        int totalLines = fileRevision.getLineCount();
        int linesAdded = fileRevision.getLinesAdded();
        int linesRemoved = fileRevision.getLinesRemoved();
        String csid = fileRevision.getChangeSetId();
        List<String> ancestors = this.getAncestorRevisions(fileRevision.getAncestors());
        String comment = fileRevision.getComment();
        String contentLink = "";
        if (!fileRevision.isDead()) {
            contentLink = "/browse/~raw,r=" + fileRevision.getRevision() + "/" + repositoryName + "/" + fileRevision.getPath();
        }
        return new FileRevisionData(path, rev, author, date, fileRevisionState, totalLines, linesAdded, linesRemoved, csid, ancestors, comment, contentLink);
    }

    @Override
    public <T> T withRepository(String repositoryName, Function<RepositoryEngine, T> repositoryOperation) {
        this.spiUserUtils.requireUserHasPermissionToAccess(repositoryName);
        RepositoryHandle repository = this.getRepositoryHandle(repositoryName);
        try {
            return repository.withEngine(repositoryOperation);
        }
        catch (RepositoryHandle.StateException e2) {
            throw new IllegalRepositoryStateException("repository is in wrong state: " + repository.getStateDescription(), (Throwable)((Object)e2));
        }
    }

    @Override
    public ReviewData createReviewData(Review review) {
        return this.applyToReviewBuilder(new ReviewData.Builder(), review).build();
    }

    @Override
    public ReviewData.Builder applyToReviewBuilder(ReviewData.Builder reviewBuilder, Review review) {
        return reviewBuilder.setPermaId(review.getPermaId()).setPermaIdHistory(review.getPermaIdHistoryAsStrings()).setProjectKey(review.getProject().getProjKey()).setName(review.getName()).setDescription(review.getDescription()).setAuthor(this.createUserData(review.getAuthor())).setModerator(this.createUserData(review.getModerator())).setCreator(this.createUserData(review.getCreator())).setSummary(review.getSummary()).setState(this.modelStateToDataState(review.getState())).setType(review.getType().getApiReviewType()).setAllowReviewersToJoin(Boolean.valueOf(review.isAllowReviewerToJoin())).setParentReview(review.getParentReview() == null ? null : new PermId(review.getParentReview().getPermaId())).setCreateDate(review.getCreateDate()).setCloseDate(review.getClosedDate()).setDueDate(review.getDueDate()).setReminderDate(review.getReminderDate()).setMetricsVersion(review.getMetricsVersion().intValue()).setJiraIssueKey(review.getJiraIssueKey());
    }

    @Override
    public ReviewData.State modelStateToDataState(State state) {
        ReviewData.State dataState = state.getStateType().getReviewDataState();
        if (dataState == null) {
            throw new RuntimeException("Unknown state " + state.getVerbage());
        }
        return dataState;
    }

    @Override
    public FisheyeReviewItemData.FileType asFileType(String type) {
        if (type != null) {
            try {
                switch (ContentManager.FileType.valueOf(type)) {
                    case FILE: {
                        return FisheyeReviewItemData.FileType.File;
                    }
                    case DIRECTORY: {
                        return FisheyeReviewItemData.FileType.Directory;
                    }
                }
                return FisheyeReviewItemData.FileType.Unknown;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return FisheyeReviewItemData.FileType.Unknown;
    }

    @Override
    public FisheyeReviewItemData.FileType convertFileType(String type) {
        return this.asFileType(type);
    }

    @Override
    public FisheyeReviewItemData.CommitType asCommitType(CrucibleRevision fileRevision) {
        if (this.isTrue(fileRevision.isAdded())) {
            return FisheyeReviewItemData.CommitType.Added;
        }
        if (this.isTrue(fileRevision.isDeletion())) {
            return FisheyeReviewItemData.CommitType.Deleted;
        }
        if (this.isTrue(fileRevision.isModified())) {
            return FisheyeReviewItemData.CommitType.Modified;
        }
        if (this.isTrue(fileRevision.isMoved())) {
            return FisheyeReviewItemData.CommitType.Moved;
        }
        if (this.isTrue(fileRevision.isCopied())) {
            return FisheyeReviewItemData.CommitType.Copied;
        }
        return FisheyeReviewItemData.CommitType.Unknown;
    }

    @Override
    public FisheyeReviewItemData.CommitType getSPICommitType(CrucibleRevision fileRevision) {
        return this.asCommitType(fileRevision);
    }

    private boolean isTrue(Boolean value) {
        return value != null && value != false;
    }

    @Override
    public String createPatchContentUrlFromPatch(Patch patch) {
        String contextPath = this.rootConfig.getContextPath();
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return String.format("%s/cru/%s/downloadpatch/%s/%s", contextPath, patch.getReview().getPermaId(), Integer.toString(patch.getId()), FishEyeURLEncoder.uriEncode(patch.getUploadItem().getOriginalName()));
    }

    @Override
    public String createRevisionContentUrlFromFRX(FRXRevision revision) {
        String contextPath = this.rootConfig.getContextPath();
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return this.createRevisionContentUrl(contextPath, revision.getFrx().getReview().getPermaId(), revision.getRevision().getId(), FishEyeURLEncoder.pathEncode(revision.getRevision().getPath()));
    }

    @Override
    public String createRevisionContentUrl(String ctx, String permaId, int revisionId, String path) {
        return String.format("%s/cru/%s/rawcontent/%s/%s", ctx, permaId, revisionId, FishEyeURLEncoder.pathEncode(path));
    }

    @Override
    public ReviewItemRevisionData buildRevisionData(FRXRevision frxRevision, boolean isPatchSource) {
        return this.createRevisionData(frxRevision, isPatchSource);
    }

    @Override
    public ReviewItemRevisionData buildRevisionData(FRXRevision frxRevision) {
        return this.createRevisionData(frxRevision);
    }

    @Override
    public ReviewItemRevisionData createRevisionData(FRXRevision frxRevision, boolean isPatchSource) {
        CrucibleRevision crurev = frxRevision.getRevision();
        String url = isPatchSource ? this.createPatchContentUrlFromPatch(this.patchManager.findPatch(crurev)) : this.createRevisionContentUrlFromFRX(frxRevision);
        ReviewItemRevisionData revisionData = new ReviewItemRevisionData(frxRevision.getDateAdded(), crurev.getRevision(), crurev.getPath(), this.asFileType(crurev.getFileType()), this.asCommitType(crurev), url, crurev.getSourceName());
        revisionData.setChangedLines(frxRevision.getLinesChanged());
        return revisionData;
    }

    @Override
    public ReviewItemRevisionData createRevisionData(FRXRevision frxRevision) {
        return this.createRevisionData(frxRevision, this.sourceFactory.isPatchSource(frxRevision.getRevision().getSourceName()));
    }

    @Override
    public FecruUser getUserFromPrincipal(Principal principal) {
        return this.spiUserUtils.getUserFromPrincipal(principal);
    }

    @Override
    public FecruUser getUserFromPrincipal(Principal principal, CrucibleUserManager userManager) {
        return this.getUserFromPrincipal(principal);
    }

    @Override
    public FecruUser getUserByName(String name) {
        return this.spiUserUtils.getUserByName(name);
    }

    @Override
    public FecruUser getUserByName(String name, CrucibleUserManager userManager) {
        return this.getUserByName(name);
    }

    @Override
    public Set<UserData> crucibleUsersToUserDataSet(Collection<FecruUser> users) {
        return this.spiUserUtils.crucibleUsersToUserDataSet(users);
    }

    @Override
    public Set<FecruUser> userDataCollectionToCrucibleUserSet(Collection<UserData> userData) {
        return this.spiUserUtils.userDataCollectionToCrucibleUserSet(userData);
    }

    @Override
    public UserData createUserData(FecruUser user) {
        return this.spiUserUtils.createUserData(user);
    }

    @Override
    public ReviewerData createReviewerData(FecruUser user, boolean completed) {
        return this.spiUserUtils.createReviewerData(user, completed);
    }

    @Override
    public ReviewerData createReviewerData(ReviewParticipant reviewer) throws IllegalArgumentException {
        return this.spiUserUtils.createReviewerData(reviewer);
    }

    @Override
    public FecruUser getUser(UserData userData) {
        return this.spiUserUtils.getUser(userData);
    }

    @Override
    public boolean hasPermissionToAccess(RepositoryHandle repositoryHandle) {
        return this.spiUserUtils.hasPermissionToAccess(repositoryHandle);
    }

    @Override
    public void requireUserHasPermissionToAccess(String repositoryName) {
        this.spiUserUtils.requireUserHasPermissionToAccess(repositoryName);
    }
}

